/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import java.io.File;
import java.util.ArrayList;

public class IlrFileUtil {
    public static String getExtension(String filepath) {
        int index = filepath.lastIndexOf(46);
        if (index != -1) {
            return filepath.substring(index);
        }
        return "";
    }

    public static String getDirectory(String filepath) {
        int index = filepath.lastIndexOf(File.separatorChar);
        if (index != -1) {
            return filepath.substring(0, index + 1);
        }
        return "";
    }

    public static String getName(String filepath) {
        int index = filepath.lastIndexOf(File.separatorChar);
        if (index != -1) {
            filepath = filepath.substring(index + 1);
        }
        if ((index = filepath.lastIndexOf(46)) != -1) {
            filepath = filepath.substring(0, index);
        }
        return filepath;
    }

    public static String newFilename(String filepath, String name, String extension) {
        if (filepath == null) {
            return name + '.' + extension;
        }
        return IlrFileUtil.getDirectory(filepath) + name + '.' + extension;
    }

    public static String removeExtension(String filepath) {
        int index = filepath.lastIndexOf(46);
        if (index != -1) {
            return filepath.substring(0, index);
        }
        return filepath;
    }

    public static String removeTerminalFileSeparator(String directory) {
        if (directory == null || directory.length() == 0) {
            return directory;
        }
        char c = directory.charAt(directory.length() - 1);
        if (c == '\\' || c == '/' || c == File.separatorChar) {
            directory = directory.substring(0, directory.length() - 1);
        }
        return directory;
    }

    public static String ensureTerminalFileSeparator(String directory) {
        if (directory == null || directory.length() == 0) {
            return directory;
        }
        char c = directory.charAt(directory.length() - 1);
        if (c != '\\' && c != '/' && c != File.separatorChar) {
            directory = directory + File.separatorChar;
        }
        return directory;
    }

    public static String replace(String filepath, char oldChar, char newChar) {
        if (filepath == null) {
            return "";
        }
        return filepath.replace(oldChar, newChar);
    }

    public static String replaceFileSeparator(String filepath, char newChar) {
        if (filepath == null) {
            return "";
        }
        filepath = filepath.replace('/', File.separatorChar);
        filepath = filepath.replace('\\', File.separatorChar);
        return filepath.replace(File.separatorChar, newChar);
    }

    public static String ensureFileSeparator(String filepath) {
        if (filepath == null) {
            return "";
        }
        filepath = filepath.replace('/', File.separatorChar);
        filepath = filepath.replace('\\', File.separatorChar);
        return filepath;
    }

    public static String getFileName(String pathname) {
        if (pathname != null) {
            char sep1 = File.separatorChar;
            int sep2 = File.separatorChar == '\\' ? 47 : 92;
            int index1 = pathname.lastIndexOf(sep1);
            int index2 = pathname.lastIndexOf(sep2);
            if (index1 == -1) {
                index1 = index2;
            } else if (index2 != -1) {
                int n = index1 = index2 < index1 ? index2 : index1;
            }
            if (index1 == -1) {
                return pathname;
            }
            return pathname.substring(index1 + 1);
        }
        return null;
    }

    static Object[] getDirectoriesList(String path) {
        int idx;
        path = path.substring(0, path.lastIndexOf(IlrFileUtil.getFileName(path)));
        char sep = File.separatorChar;
        char sep2 = sep == '\\' ? (char)'/' : '\\';
        int index1 = path.indexOf(sep);
        int index2 = path.indexOf(sep2);
        if (index1 == -1) {
            sep = sep2;
        } else {
            path = path.replace(sep2, sep);
        }
        ArrayList<String> array = new ArrayList<String>();
        while ((idx = path.indexOf(sep)) != -1) {
            String dir = path.substring(0, idx);
            if (dir.length() > 0) {
                array.add(dir);
            }
            path = path.substring(idx + 1);
        }
        if (path != null && path.length() > 0) {
            array.add(path);
        }
        return array.toArray();
    }

    public static String normalize(String p) {
        boolean isUNC = p.startsWith("\\");
        if (p.indexOf("..") == -1 && p.indexOf(".") == -1) {
            return p;
        }
        String clone = new String(p);
        clone = IlrFileUtil.ensureFileSeparator(clone);
        String prefix = "";
        String defaultprefix = ".." + File.separator;
        while (clone.startsWith(defaultprefix)) {
            prefix = prefix + clone.substring(0, defaultprefix.length());
            clone = clone.substring(defaultprefix.length());
        }
        if (clone == null || clone.length() == 0) {
            return null;
        }
        String path = clone.startsWith("/") ? "/" : "";
        String fileName = IlrFileUtil.getFileName(clone);
        Object[] dirs = IlrFileUtil.getDirectoriesList(clone);
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].equals("..")) {
                int idx = (path = path.substring(0, path.length() - 1)).lastIndexOf(File.separator);
                if (idx != -1) {
                    path = path.substring(0, path.lastIndexOf(File.separator)) + File.separator;
                    continue;
                }
                path = "";
                continue;
            }
            if (dirs[i].equals(".")) continue;
            path = path.concat((String)dirs[i] + File.separator);
        }
        if (fileName != null && fileName.length() > 0) {
            path = path.concat(fileName);
        }
        return isUNC ? "\\\\" + prefix + path : prefix + path;
    }

    public static boolean isAbsolute(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isAbsolute();
    }

    public static File[] remove(File[] src, int index) {
        if (src == null || src.length == 0 || index == -1) {
            return src;
        }
        File[] newArray = new File[src.length - 1];
        if (index > 0) {
            System.arraycopy(src, 0, newArray, 0, index);
        }
        if (index < src.length - 1) {
            System.arraycopy(src, index + 1, newArray, index, src.length - index - 1);
        }
        return newArray;
    }

    public static File[] remove(File[] src, File file) {
        return IlrFileUtil.remove(src, IlrFileUtil.indexOf(src, file));
    }

    public static File[] add(File[] src, File file, int index) {
        if (src == null || src.length == 0) {
            return new File[]{file};
        }
        File[] newArray = new File[src.length + 1];
        if (index > 0) {
            System.arraycopy(src, 0, newArray, 0, index);
        }
        newArray[index] = file;
        if (index < src.length) {
            System.arraycopy(src, index, newArray, index + 1, src.length - index);
        }
        return newArray;
    }

    public static File[] add(File[] src, File file) {
        return IlrFileUtil.add(src, file, src == null ? 0 : src.length);
    }

    public static int indexOf(File[] src, Object file) {
        if (src == null || src.length == 0 || file == null) {
            return -1;
        }
        for (int iFile = 0; iFile < src.length; ++iFile) {
            if (!file.equals(src[iFile])) continue;
            return iFile;
        }
        return -1;
    }

    public static File[] copy(File[] src) {
        if (src == null || src.length == 0) {
            return new File[0];
        }
        File[] newArray = new File[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        return newArray;
    }

    public static File[] merge(File[] array1, File[] array2) {
        return IlrFileUtil.merge(array1, array2, false);
    }

    public static File[] merge(File[] array1, File[] array2, boolean first) {
        if (array1 == null && array2 == null) {
            return new File[0];
        }
        if (array1 != null && array2 == null) {
            return array1;
        }
        if (array1 == null && array2 != null) {
            return array2;
        }
        File[] result = IlrFileUtil.copy(array2);
        for (int i = array1.length - 1; i >= 0; --i) {
            int index = IlrFileUtil.indexOf(result, array1[i]);
            if (index != -1) continue;
            result = first ? IlrFileUtil.add(result, array1[i], 0) : IlrFileUtil.add(result, array1[i]);
        }
        return result;
    }
}

