/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrLanguageDescription;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class IlrIdConverter {
    public static final String IRL_SEPARATOR = "#";
    public static final char ENGINE_TASK_SEPARATOR = '#';
    public static final char BUSINESS_TASK_SEPARATOR = '>';
    public static final char ESCAPE_CHAR = '$';
    public static final char PACKAGE_SEPARATOR = '.';
    private static Pattern DOTPATTERN = Pattern.compile("\\.");
    private static final Map<String, String> KEYWORD_ESCAPED;

    public static String getEngineIdentifier(String businessIdentifier) {
        if (businessIdentifier == null || businessIdentifier.length() == 0) {
            return businessIdentifier;
        }
        String[] tokens = DOTPATTERN.split(businessIdentifier);
        StringBuilder sb = new StringBuilder(businessIdentifier.length());
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.equals("*")) {
                sb.append(token);
            } else {
                sb.append(IlrIdConverter.getEngineTokenIdentifier(token));
            }
            if (i >= tokens.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static String getEngineTokenIdentifier(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return identifier;
        }
        String escapedKeyword = KEYWORD_ESCAPED.get(identifier);
        if (escapedKeyword != null) {
            return escapedKeyword;
        }
        StringBuilder sb = new StringBuilder(identifier.length());
        char c = identifier.charAt(0);
        switch (c) {
            case '$': {
                sb.append('$').append('$');
                break;
            }
            case ' ': {
                sb.append('_');
                break;
            }
            case '_': {
                sb.append('$').append(c).append('$');
                break;
            }
            case '>': {
                sb.append('#');
                break;
            }
            default: {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                    break;
                }
                sb.append('$').append((int)c).append('$');
            }
        }
        block12: for (int i = 1; i < identifier.length(); ++i) {
            c = identifier.charAt(i);
            switch (c) {
                case '$': {
                    sb.append('$').append('$');
                    continue block12;
                }
                case ' ': {
                    sb.append('_');
                    continue block12;
                }
                case '_': {
                    sb.append('$').append(c).append('$');
                    continue block12;
                }
                case '>': {
                    sb.append('#');
                    continue block12;
                }
                default: {
                    if (Character.isJavaIdentifierPart(c)) {
                        sb.append(c);
                        continue block12;
                    }
                    sb.append('$').append((int)c).append('$');
                }
            }
        }
        return sb.toString();
    }

    public static String getBusinessIdentifier(String identifier) {
        return IlrIdConverter.getBusinessTokenIdentifier(identifier);
    }

    public static String getBusinessTokenIdentifier(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return identifier;
        }
        StringBuilder businessIdentifier = new StringBuilder(identifier.length());
        StringBuilder escapedSequence = new StringBuilder(10);
        boolean escape = false;
        int escapedCode = 0;
        boolean escapedCodeValid = true;
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (!escape) {
                switch (c) {
                    case '$': {
                        escape = true;
                        break;
                    }
                    case '_': {
                        businessIdentifier.append(' ');
                        break;
                    }
                    case '#': {
                        businessIdentifier.append('>');
                        break;
                    }
                    default: {
                        businessIdentifier.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c != '$') {
                escapedSequence.append(c);
                if (c >= '0' && c <= '9') {
                    escapedCode = escapedCode * 10 + (c - 48);
                    continue;
                }
                escapedCodeValid = false;
                continue;
            }
            escape = false;
            if (escapedSequence.length() == 0) {
                businessIdentifier.append('$');
            } else if (escapedSequence.length() == 1 && escapedSequence.charAt(0) == '_') {
                businessIdentifier.append('_');
            } else if (escapedCodeValid) {
                businessIdentifier.append((char)escapedCode);
            } else {
                businessIdentifier.append('$').append((CharSequence)escapedSequence).append('$');
            }
            escapedSequence.delete(0, escapedSequence.length());
            escapedCodeValid = true;
            escapedCode = 0;
        }
        if (escape) {
            businessIdentifier.append((CharSequence)escapedSequence);
        }
        return businessIdentifier.toString();
    }

    public static String getRuleFlowName(String taskName) {
        return IlrIdConverter.getRuleFlowName(taskName, '#');
    }

    public static String getRuleFlowNameFromBusinessName(String taskName) {
        return IlrIdConverter.getRuleFlowName(taskName, '>');
    }

    private static String getRuleFlowName(String taskName, char separator) {
        int position = taskName.lastIndexOf(separator);
        if (position > 0) {
            return taskName.substring(0, position);
        }
        return null;
    }

    public static String getTaskName(String taskName) {
        return IlrIdConverter.getTaskName(taskName, '#');
    }

    public static String getTaskNameFromBusinessName(String taskName) {
        return IlrIdConverter.getTaskName(taskName, '>');
    }

    private static String getTaskName(String taskName, char taskSeparator) {
        int position = taskName.lastIndexOf(taskSeparator);
        if (position > 0) {
            return taskName.substring(position + 1);
        }
        return null;
    }

    static {
        String[] irlKeywords = IlrLanguageDescription.irl;
        String[] omKeywords = IlrLanguageDescription.jom;
        KEYWORD_ESCAPED = new HashMap<String, String>(irlKeywords.length + omKeywords.length);
        for (String irlKeyword : irlKeywords) {
            KEYWORD_ESCAPED.put(irlKeyword, '$' + irlKeyword);
        }
        for (String omKeyword : omKeywords) {
            KEYWORD_ESCAPED.put(omKeyword, '$' + omKeyword);
        }
    }
}

