/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrParserUtilities {
    public static Number parseIntegerLiteral(String str) throws NumberFormatException {
        if (str.charAt(0) == '-') {
            return IlrParserUtilities.parseIntegerLiteral(str.substring(1), -1);
        }
        return IlrParserUtilities.parseIntegerLiteral(str, 1);
    }

    public static Number parseIntegerLiteral(String str, int sign) throws NumberFormatException {
        String prefix;
        int len = str.length();
        char last = str.charAt(len - 1);
        String string = prefix = sign == 1 ? "" : "-";
        if (Character.toLowerCase(last) != 'l') {
            try {
                String value = str;
                if (value.startsWith("0x")) {
                    return Integer.valueOf(prefix + value.substring(2), 16);
                }
                if (value.startsWith("0") && value.length() > 1) {
                    return Integer.valueOf(prefix + value.substring(1), 8);
                }
                return Integer.valueOf(prefix + value);
            }
            catch (NumberFormatException ex) {
                throw new IntegerFormatException(ex);
            }
        }
        try {
            String value = str.substring(0, len - 1);
            if (value.startsWith("0x")) {
                return Long.valueOf(prefix + value.substring(2), 16);
            }
            if (value.startsWith("0") && value.length() > 1) {
                return Long.valueOf(prefix + value.substring(1), 8);
            }
            return Long.valueOf(prefix + value);
        }
        catch (NumberFormatException ex) {
            throw new LongFormatException(ex);
        }
    }

    public static Number parseFloatLiteral(String str) {
        if (str.charAt(0) == '-') {
            return IlrParserUtilities.parseFloatLiteral(str.substring(1), -1);
        }
        return IlrParserUtilities.parseFloatLiteral(str, 1);
    }

    public static Number parseFloatLiteral(String str, int sign) {
        String valuestring;
        String prefix;
        int len = str.length();
        char last = str.charAt(len - 1);
        boolean doubleType = false;
        String string = prefix = sign == 1 ? "" : "-";
        if (Character.toLowerCase(last) == 'f') {
            doubleType = false;
            valuestring = prefix + str.substring(0, len - 1);
        } else if (Character.toLowerCase(last) == 'd') {
            doubleType = true;
            valuestring = prefix + str.substring(0, len - 1);
        } else {
            doubleType = true;
            valuestring = prefix + str;
        }
        if (!doubleType) {
            try {
                Float x = Float.valueOf(valuestring);
                return x;
            }
            catch (NumberFormatException ex) {
                throw new FloatFormatException(ex);
            }
        }
        try {
            Double x = Double.valueOf(valuestring);
            return x;
        }
        catch (NumberFormatException ex) {
            throw new DoubleFormatException(ex);
        }
    }

    public static Character parseCharacterLiteral(String str) {
        char input;
        int index = 0;
        if ((input = str.charAt(index++)) != '\\' && input != '\'') {
            if (str.length() != index) {
                throw new IllegalArgumentException();
            }
            return Character.valueOf(input);
        }
        if (input == '\'') {
            input = str.charAt(index++);
            if (str.length() != 3) {
                throw new IllegalArgumentException();
            }
            if (str.charAt(index++) == '\'') {
                return Character.valueOf(input);
            }
            throw new IllegalArgumentException();
        }
        input = str.charAt(index++);
        if (str.length() != index) {
            throw new IllegalArgumentException();
        }
        switch (input) {
            case 'n': {
                return Character.valueOf('\n');
            }
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case 'f': {
                return Character.valueOf('\f');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
        }
        return null;
    }

    public static String parseStringLiteral(String str) {
        int len = str.length();
        StringBuilder buffer = new StringBuilder(len);
        int index = 0;
        while (index < len) {
            char input;
            if ((input = str.charAt(index++)) != '\\' || index == len) {
                buffer.append(input);
                continue;
            }
            input = str.charAt(index++);
            switch (input) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                }
            }
        }
        return buffer.toString();
    }

    public static class DoubleFormatException
    extends NumberFormatException {
        public DoubleFormatException(NumberFormatException e) {
            super(e.getMessage());
        }
    }

    public static class FloatFormatException
    extends NumberFormatException {
        public FloatFormatException(NumberFormatException e) {
            super(e.getMessage());
        }
    }

    public static class LongFormatException
    extends NumberFormatException {
        public LongFormatException(NumberFormatException e) {
            super(e.getMessage());
        }
    }

    public static class IntegerFormatException
    extends NumberFormatException {
        public IntegerFormatException(NumberFormatException e) {
            super(e.getMessage());
        }
    }
}

