/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlrSelector {
    Map methods = new HashMap();

    public boolean areAccepted(Collection collection) {
        if (collection == null) {
            return true;
        }
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.isAccepted(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isAccepted(Object o) {
        if (o == null) {
            return false;
        }
        Method method = IlrVisitor.getMethod(this.getClass(), "accepts", o.getClass(), this.methods);
        if (method != null) {
            try {
                Boolean result = (Boolean)method.invoke((Object)this, o);
                return result;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != e) {
                    e.getTargetException().printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            return this.accepts(o);
        }
        return false;
    }

    public boolean accepts(Object o) {
        return false;
    }

    public static class And
    extends IlrSelector {
        private IlrSelector firstSelector;
        private IlrSelector secondSelector;

        public And(IlrSelector firstSelector, IlrSelector secondSelector) {
            this.firstSelector = firstSelector;
            this.secondSelector = secondSelector;
        }

        @Override
        public boolean isAccepted(Object o) {
            return this.firstSelector.isAccepted(o) && this.secondSelector.isAccepted(o);
        }
    }

    public static class Or
    extends IlrSelector {
        private IlrSelector firstSelector;
        private IlrSelector secondSelector;

        public Or(IlrSelector firstSelector, IlrSelector secondSelector) {
            this.firstSelector = firstSelector;
            this.secondSelector = secondSelector;
        }

        @Override
        public boolean isAccepted(Object o) {
            return this.firstSelector.isAccepted(o) || this.secondSelector.isAccepted(o);
        }
    }

    public static class Not
    extends IlrSelector {
        private IlrSelector selector;

        public Not(IlrSelector selector) {
            this.selector = selector;
        }

        @Override
        public boolean isAccepted(Object o) {
            return !this.selector.isAccepted(o);
        }
    }
}

