/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrURI;
import ilog.rules.util.prefs.IlrMessages;

public class IlrURIUtils {
    public static String getExtension(IlrURI uri) {
        String ext = null;
        String s = uri.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isFiltered(IlrURI uri, String[] extensions) {
        boolean filtered = false;
        String extension = IlrURIUtils.getExtension(uri);
        if (extension != null) {
            for (int i = 0; i < extensions.length; ++i) {
                if (!extension.equalsIgnoreCase(extensions[i])) continue;
                filtered = true;
                break;
            }
        }
        return filtered;
    }

    public static String extractRootId(String pathname) {
        int index1 = pathname.indexOf("[");
        int index2 = pathname.indexOf("]:");
        if (index1 == 0 && index2 != -1 && index2 > index1) {
            return pathname.substring(index1 + 1, index2);
        }
        return null;
    }

    public static String extractPathname(String pathname) {
        int index1 = pathname.indexOf("[");
        int index2 = pathname.indexOf("]:");
        if (index1 == 0 && index2 != -1 && index2 > index1) {
            return pathname.substring(index2 + 2);
        }
        return pathname;
    }

    public static String makeRelativePathName(String pathname, String rootId) {
        if (rootId == null) {
            return pathname;
        }
        return "[" + rootId + "]:" + pathname;
    }

    public static String makeRelativeDisplayPathName(String pathname, String rootId) {
        if (rootId == null) {
            return pathname;
        }
        String display = IlrMessages.getMessage(rootId);
        return "[" + display + "]:" + pathname;
    }
}

