/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrVisitable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IlrVisitor {
    private static String INSPECT_METHOD_NAME = "inspect";
    Map methods = new HashMap();

    public void iterateVisit(Collection collection) {
        if (collection == null) {
            return;
        }
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.visit(i.next());
        }
    }

    public void iterateVisit(Iterator i) {
        if (i == null) {
            return;
        }
        while (i.hasNext()) {
            this.visit(i.next());
        }
    }

    public void visit(Object o) {
        block9: {
            if (o == null) {
                return;
            }
            Method method = IlrVisitor.getMethod(this.getClass(), INSPECT_METHOD_NAME, o.getClass(), this.methods);
            if (method != null) {
                try {
                    method.invoke((Object)this, o);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != e) {
                        e.getTargetException().printStackTrace();
                        break block9;
                    }
                    e.printStackTrace();
                }
            } else {
                this.inspect(o);
            }
        }
        if (o instanceof IlrVisitable) {
            this.callAccept((IlrVisitable)o);
        }
    }

    protected void callAccept(IlrVisitable visitable) {
        visitable.accept(this);
    }

    public void inspect(Object o) {
    }

    protected static Method getMethod(Class visitorClass, String methodName, Class visitedObjectClass, Map methodCache) {
        Method m = (Method)methodCache.get(visitedObjectClass);
        if (m != null) {
            return m;
        }
        Class newc = visitedObjectClass;
        HashSet interfacesToTest = new HashSet();
        while (m == null && newc != Object.class) {
            try {
                m = visitorClass.getMethod(methodName, newc);
            }
            catch (NoSuchMethodException e) {
                IlrVisitor.mergeInterfaces(interfacesToTest, newc.getInterfaces());
                newc = newc.getSuperclass();
            }
        }
        if (newc == Object.class) {
            List interfaces = IlrVisitor.sortInterfaces(interfacesToTest);
            for (int i = 0; i < interfaces.size() && (m = (Method)methodCache.get(newc = (Class)interfaces.get(i))) == null; ++i) {
                try {
                    m = visitorClass.getMethod(methodName, newc);
                    break;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        if (m != null && !Proxy.isProxyClass(visitedObjectClass)) {
            methodCache.put(visitedObjectClass, m);
        }
        return m;
    }

    static void mergeInterfaces(Set interfaces, Class[] interfaceToAdd) {
        for (int i = 0; i < interfaceToAdd.length; ++i) {
            Class anInterface = interfaceToAdd[i];
            if (interfaces.contains(anInterface)) continue;
            interfaces.add(anInterface);
            if (anInterface.getInterfaces().length == 0) continue;
            IlrVisitor.mergeInterfaces(interfaces, anInterface.getInterfaces());
        }
    }

    static List sortInterfaces(Set interfaces) {
        ArrayList<Class> result = new ArrayList<Class>(interfaces.size());
        for (Class anInterface : interfaces) {
            boolean inserted = false;
            for (int j = 0; j < result.size(); ++j) {
                Class sortedInterface = (Class)result.get(j);
                if (!sortedInterface.isAssignableFrom(anInterface)) continue;
                result.add(j, anInterface);
                inserted = true;
                break;
            }
            if (inserted) continue;
            result.add(anInterface);
        }
        return result;
    }
}

