/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.engine;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayListOfWeakReferences<T>
implements Iterable<T> {
    private ArrayList<WeakReference<T>> list;

    public void add(T t) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        if (!this.contains(t)) {
            this.list.add(new WeakReference<T>(t));
        }
    }

    public boolean contains(T t) {
        if (this.list == null) {
            return false;
        }
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            Object current = this.list.get(i).get();
            if (t != current) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (this.list.get(i).get() == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean remove(T t) {
        if (this.list == null) {
            return false;
        }
        Iterator<WeakReference<T>> i = this.list.iterator();
        boolean removed = false;
        while (i.hasNext()) {
            WeakReference<T> ref = i.next();
            Object current = ref.get();
            if (current == null) {
                i.remove();
                continue;
            }
            if (current != t) continue;
            i.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list == null) {
            return Collections.emptyList().iterator();
        }
        return new Iter();
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    private class Iter
    implements Iterator<T> {
        int index;
        T current;
        boolean hasNextCalled;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            this.hasNextCalled = true;
            while (true) {
                if (this.index == ArrayListOfWeakReferences.this.list.size()) {
                    return false;
                }
                WeakReference ref = (WeakReference)ArrayListOfWeakReferences.this.list.get(this.index);
                this.current = ref.get();
                if (this.current != null) break;
                ArrayListOfWeakReferences.this.list.remove(this.index);
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.current;
            this.current = null;
            ++this.index;
            this.hasNextCalled = false;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

