/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.issue;

import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrFormattedMessage;
import ilog.rules.util.issue.IlrWarning;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class IlrErrorException
extends RuntimeException {
    private transient Collection<IlrFormattedMessage> locations;
    private transient Collection<IlrError> errors;
    private transient Collection<IlrWarning> warnings;

    public IlrErrorException() {
        this.errors = Collections.emptyList();
        this.warnings = Collections.emptyList();
    }

    public IlrErrorException(IlrError ... errors) {
        this.errors = Arrays.asList(errors);
        this.warnings = Collections.emptyList();
    }

    public IlrErrorException(Collection<IlrError> errors, Collection<IlrWarning> warnings) {
        this.errors = errors != null ? new ArrayList<IlrError>(errors) : Collections.emptyList();
        this.warnings = warnings != null ? new ArrayList<IlrWarning>(warnings) : Collections.emptyList();
    }

    public IlrErrorException(IlrError[] errors, IlrWarning[] warnings) {
        this.errors = errors != null ? Arrays.asList(errors) : Collections.emptyList();
        this.warnings = warnings != null ? Arrays.asList(warnings) : Collections.emptyList();
    }

    public void addLocation(IlrFormattedMessage location) {
        if (this.locations == null) {
            this.locations = new ArrayList<IlrFormattedMessage>();
        }
        this.locations.add(location);
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public String getMessage(Locale locale) {
        return this.toString(locale);
    }

    public Collection<IlrError> getErrors() {
        return this.errors;
    }

    public Collection<IlrWarning> getWarnings() {
        return this.warnings;
    }

    public Collection<IlrFormattedMessage> getLocations() {
        return this.locations == null ? Collections.emptyList() : this.locations;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        String[] tmpErrorIds = new String[this.errors.size()];
        String[] tmpErrors = new String[this.errors.size()];
        Locale defaultLocale = Locale.getDefault();
        this.errorsToStringArray(defaultLocale, true, tmpErrors, tmpErrorIds, 0);
        String[] tmpWarningIds = new String[this.warnings.size()];
        String[] tmpWarnings = new String[this.warnings.size()];
        this.warningsToStringArray(defaultLocale, true, tmpWarnings, tmpWarningIds, 0);
        stream.writeObject(tmpErrorIds);
        stream.writeObject(tmpErrors);
        stream.writeObject(tmpWarningIds);
        stream.writeObject(tmpWarnings);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int i;
        stream.defaultReadObject();
        String[] tmpErrorIds = (String[])stream.readObject();
        String[] tmpErrors = (String[])stream.readObject();
        String[] tmpWarningIds = (String[])stream.readObject();
        String[] tmpWarnings = (String[])stream.readObject();
        this.errors = new ArrayList<IlrError>(tmpErrors.length);
        for (i = 0; i < tmpErrorIds.length; ++i) {
            this.errors.add(new IlrError("", tmpErrorIds[i], tmpErrors[i]));
        }
        this.warnings = new ArrayList<IlrWarning>(tmpWarnings.length);
        for (i = 0; i < tmpWarnings.length; ++i) {
            this.warnings.add(new IlrWarning("", tmpWarningIds[i], tmpWarnings[i]));
        }
    }

    public String[] toStringArray() {
        return this.toStringArray(Locale.getDefault());
    }

    public String[] toStringArray(Locale locale) {
        String[] strs = new String[this.errors.size() + this.warnings.size()];
        int j = 0;
        j = this.errorsToStringArray(locale, false, strs, null, j);
        this.warningsToStringArray(locale, false, strs, null, j);
        return strs;
    }

    private void warningsToStringArray(Locale locale, boolean forser, String[] strs, String[] ids, int j) {
        for (IlrWarning warning : this.warnings) {
            String string = strs[j] = forser ? warning.getMessage(locale, false) : warning.getMessageWithLocation(locale);
            if (ids != null) {
                ids[j] = warning.getMessageId();
            }
            ++j;
        }
    }

    private int errorsToStringArray(Locale locale, boolean forser, String[] strs, String[] ids, int j) {
        for (IlrError error : this.errors) {
            String string = strs[j] = forser ? error.getMessage(locale, false) : error.getMessageWithLocation(locale);
            if (ids != null) {
                ids[j] = error.getMessageId();
            }
            ++j;
        }
        return j;
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        StringBuilder buf = new StringBuilder();
        if (this.locations != null) {
            for (IlrFormattedMessage location : this.locations) {
                buf.append('\t');
                buf.append(location.getMessage(locale));
                buf.append('\n');
            }
        }
        for (IlrError error : this.errors) {
            buf.append(error.getMessageWithLocation(locale));
            buf.append('\n');
        }
        for (IlrWarning warning : this.warnings) {
            buf.append(warning.getMessageWithLocation(locale));
            buf.append('\n');
        }
        return buf.toString();
    }
}

