/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.issue;

import ilog.rules.util.issue.IlrDefaultFormattedMessage;
import ilog.rules.util.issue.IlrFormattedMessage;
import java.util.Locale;

public class IlrIssue
extends IlrDefaultFormattedMessage {
    protected IlrFormattedMessage location;
    protected Exception sourceException;

    public IlrIssue(String baseName, String id, Object ... parameters) {
        super(baseName, id, parameters);
    }

    public IlrIssue(String baseName, String id, Exception sourceException, Object ... parameters) {
        super(baseName, id, parameters);
        this.sourceException = sourceException;
    }

    public IlrIssue(String baseName, String id, Exception sourceException) {
        super(baseName, id, new Object[0]);
        this.sourceException = sourceException;
    }

    public void setLocation(IlrFormattedMessage location) {
        this.location = location;
    }

    public IlrFormattedMessage getLocation() {
        return this.location;
    }

    public Exception getSourceException() {
        return this.sourceException;
    }

    public String getMessageWithLocation() {
        if (this.location != null) {
            return this.location.getMessage() + " " + this.getMessage();
        }
        return this.getMessage();
    }

    public String getMessageWithLocation(Locale locale) {
        if (this.location != null) {
            return this.location.getMessage(locale) + " " + this.getMessage(locale);
        }
        return this.getMessage(locale);
    }

    @Override
    public String getMessage(Locale locale) {
        return this.getMessage(locale, true);
    }

    String getMessage(Locale locale, boolean writeId) {
        StringBuilder sb = new StringBuilder();
        if (writeId) {
            sb.append(this.getMessageId());
            sb.append(": ");
        }
        if (this.sourceException != null) {
            sb.append(this.sourceException.toString());
            sb.append(" ");
        }
        sb.append(super.getMessage(locale));
        return sb.toString();
    }

    public String toString() {
        return this.getMessage();
    }
}

