/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import ilog.rules.util.prefs.IlrPropertyManager;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;

public class IlrMessages
extends IlrPropertyManager {
    private static IlrMessages messages;

    public static IlrMessages getMessages() {
        if (messages == null) {
            IlrMessages.init();
        }
        return messages;
    }

    private static synchronized void init() {
        if (messages == null) {
            messages = new IlrMessages();
            messages.setPrefixes(new String[]{"ilog.rules", ""});
            messages.setSuffixes(new String[]{""});
        }
    }

    protected IlrMessages() {
    }

    @Override
    protected String getBaseClassName() {
        return "messages";
    }

    public static char getChar(String key, char defaultValue) {
        return IlrMessages.getChar(null, key, defaultValue);
    }

    public static char getChar(IlrPropertyBundle bundle, String key, char defaultValue) {
        String s = IlrMessages.getMessageString(bundle, key);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return s.charAt(0);
    }

    public static String getMessage(String key) {
        return IlrMessages.getMessage((IlrPropertyBundle)null, key);
    }

    public static String getMessage(String key, Locale locale) {
        String v = IlrMessages.getMessageString(key, locale);
        if (v == null) {
            return key;
        }
        return v;
    }

    public static String getMessage(IlrPropertyBundle bundle, String key) {
        String v = IlrMessages.getMessageString(bundle, key);
        if (v == null) {
            return key;
        }
        return v;
    }

    public static String getMessage(String key, String defaultValue) {
        return IlrMessages.getMessage((IlrPropertyBundle)null, key, defaultValue);
    }

    public static String getMessage(String key, String defaultValue, Locale locale) {
        String v = IlrMessages.getMessageString(key, locale);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String key, String defaultValue, boolean nostop) {
        IlrMessages ilrMessages = IlrMessages.getMessages();
        synchronized (ilrMessages) {
            String string;
            IlrMessages propBundle = IlrMessages.getMessages();
            try {
                propBundle.setNoStopSearch(true);
                string = IlrMessages.getMessage(key, defaultValue);
            }
            catch (Throwable throwable) {
                propBundle.setNoStopSearch(false);
                throw throwable;
            }
            propBundle.setNoStopSearch(false);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String key, String defaultValue, boolean nostop, Locale locale) {
        IlrMessages ilrMessages = IlrMessages.getMessages();
        synchronized (ilrMessages) {
            String string;
            IlrMessages propBundle = IlrMessages.getMessages();
            try {
                propBundle.setNoStopSearch(true);
                string = IlrMessages.getMessage(key, defaultValue, locale);
            }
            catch (Throwable throwable) {
                propBundle.setNoStopSearch(false);
                throw throwable;
            }
            propBundle.setNoStopSearch(false);
            return string;
        }
    }

    public static String getMessage(IlrPropertyBundle bundle, String key, String defaultValue) {
        String v = IlrMessages.getMessageString(bundle, key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public static String getMessage(String key, Object[] args) {
        return IlrMessages.getMessage(null, key, args);
    }

    public static String getMessage(String key, Object[] args, Locale locale) {
        String str = IlrMessages.getMessageString(key, locale);
        if (str == null) {
            str = key;
        }
        return MessageFormat.format(str, IlrMessages.patchArguments(args));
    }

    public static String getMessage(IlrPropertyBundle bundle, String key, Object[] args) {
        String str = IlrMessages.getMessageString(bundle, key);
        if (str == null) {
            str = key;
        }
        return MessageFormat.format(str, IlrMessages.patchArguments(args));
    }

    public static String getMessage(IlrPropertyBundle bundle, String key, String defaultValue, Object[] args) {
        String str = IlrMessages.getMessageString(null, key);
        if (str == null) {
            return defaultValue;
        }
        return MessageFormat.format(str, IlrMessages.patchArguments(args));
    }

    public static int getInt(String key, int defaultValue) {
        int returnValue = 0;
        try {
            returnValue = Integer.valueOf(IlrMessages.getMessage(key, Integer.toString(defaultValue)));
        }
        catch (Exception e) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    public static String unquote(String message) {
        boolean quoted;
        int len = message.length();
        boolean bl = quoted = len >= 2 && message.charAt(0) == '\"' && message.charAt(len - 1) == '\"';
        if (quoted) {
            return message.substring(1, len - 1);
        }
        return message;
    }

    private static Object[] patchArguments(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i] instanceof Number || args[i] instanceof Date) continue;
            args[i] = args[i].toString();
        }
        return args;
    }

    private static String getMessageString(IlrPropertyBundle bundle, String key) {
        if (bundle == null) {
            return IlrMessages.getMessages().getValue(key);
        }
        return bundle.getString(key);
    }

    private static String getMessageString(String key, Locale locale) {
        return IlrMessages.getMessages().getValue(key, locale);
    }

    public static String format(String key, Object arg0) {
        return IlrMessages.getMessage(null, key, new Object[]{arg0});
    }

    public static String format(String key, Object arg0, Object arg1) {
        return IlrMessages.getMessage(null, key, new Object[]{arg0, arg1});
    }

    public static String format(String key, Object arg0, Object arg1, Object arg2) {
        return IlrMessages.getMessage(null, key, new Object[]{arg0, arg1, arg2});
    }

    public static String format(String key, Object[] args) {
        return IlrMessages.getMessage(null, key, args);
    }
}

