/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.resources;

import ilog.rules.util.resources.IlrCharStream;
import ilog.rules.util.resources.IlrConstants;
import ilog.rules.util.resources.IlrTokenManager;
import ilog.rules.util.resources.Token;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class IlrPropertyParser
implements IlrConstants {
    PrintWriter out = new PrintWriter(System.out, true);
    IlrCharStream charStream;
    IlrTokenManager source;
    Token current;
    Stack parents = new Stack();
    String currentNode;
    Hashtable map;
    boolean returnStatus;

    IlrPropertyParser() {
    }

    void reset(Hashtable map) {
        this.current = null;
        this.parents.removeAllElements();
        this.currentNode = null;
        this.map = map;
    }

    void initSource(Reader reader) {
        if (this.charStream == null) {
            this.charStream = new IlrCharStream(reader);
        } else {
            this.charStream.ReInit(reader);
        }
        if (this.source == null) {
            this.source = new IlrTokenManager(this.charStream);
        } else {
            this.source.ReInit(this.charStream);
        }
        this.nextToken();
    }

    boolean parse(Reader reader, Hashtable map) {
        this.returnStatus = true;
        this.reset(map);
        this.initSource(reader);
        Token t = this.current;
        while (t.kind != 0 && t.kind != 0) {
            if (t.kind == 24 && t.image.equals("node")) {
                this.nextToken();
                this.parseNode();
            } else {
                this.printError("expecting keyword 'node'");
                this.nextItem(true);
            }
            t = this.current;
        }
        this.reset(null);
        return this.returnStatus;
    }

    void enterNode(String name) {
        if (this.currentNode != null) {
            name = this.currentNode + "." + name;
        }
        this.currentNode = name;
        this.parents.push(name);
    }

    void exitNode() {
        this.parents.pop();
        this.currentNode = this.parents.isEmpty() ? null : (String)this.parents.peek();
    }

    void addProperty(String name, Object value) {
        this.map.put(this.currentNode + "." + name, value);
    }

    void printError(String message) {
        this.returnStatus = false;
        Token t = this.current;
        this.out.print("Line ");
        this.out.print(t.beginLine);
        this.out.print(": ");
        this.out.print(message);
        this.out.print(" instead of ");
        this.out.print('\'');
        this.out.print(t.image);
        this.out.print('\'');
        this.out.println();
    }

    private Number parseIntegerLiteral(Token t) {
        String str = t.image;
        int len = str.length();
        char last = str.charAt(len - 1);
        if (Character.toLowerCase(last) != 'l') {
            try {
                return Integer.decode(str);
            }
            catch (NumberFormatException ex) {
                this.printError("int number format error on " + str);
                return 0;
            }
        }
        try {
            String value = str.substring(0, len - 1);
            if (value.startsWith("0x")) {
                return Long.valueOf(value.substring(2), 16);
            }
            if (value.startsWith("0") && value.length() > 1) {
                return Long.valueOf(value.substring(1), 8);
            }
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            this.printError("long number format error on " + str);
            return new Long(0L);
        }
    }

    private Number parseFloatLiteral(Token t) {
        String valuestring;
        String str = t.image;
        int len = str.length();
        char last = str.charAt(len - 1);
        boolean doubleType = false;
        if (Character.toLowerCase(last) == 'f') {
            doubleType = false;
            valuestring = str.substring(0, len - 1);
        } else if (Character.toLowerCase(last) == 'd') {
            doubleType = true;
            valuestring = str.substring(0, len - 1);
        } else {
            doubleType = true;
            valuestring = str;
        }
        if (!doubleType) {
            try {
                Float x = Float.valueOf(valuestring);
                if (x.isInfinite()) {
                    this.printError("float number is infinite " + str);
                }
                return x;
            }
            catch (NumberFormatException ex) {
                this.printError("float number format error on " + str);
                return new Float(0.0f);
            }
        }
        try {
            Double x = Double.valueOf(valuestring);
            if (x.isInfinite()) {
                this.printError("double number is infinite " + str);
            }
            return x;
        }
        catch (NumberFormatException ex) {
            this.printError("double number format error on " + str);
            return new Double(0.0);
        }
    }

    private Character parseCharacterLiteral(String str) {
        char input;
        int index = 0;
        if ((input = str.charAt(index++)) != '\\') {
            return new Character(input);
        }
        input = str.charAt(index++);
        switch (input) {
            case 'n': {
                return new Character('\n');
            }
            case 't': {
                return new Character('\t');
            }
            case 'b': {
                return new Character('\b');
            }
            case 'r': {
                return new Character('\r');
            }
            case 'f': {
                return new Character('\f');
            }
            case '\\': {
                return new Character('\\');
            }
            case '\'': {
                return new Character('\'');
            }
            case '\"': {
                return new Character('\"');
            }
        }
        return null;
    }

    private static String parseStringLiteral(String str) {
        int len = str.length();
        StringBuilder buffer = new StringBuilder(len);
        int index = 0;
        while (index < len) {
            char input;
            if ((input = str.charAt(index++)) != '\\') {
                buffer.append(input);
                continue;
            }
            input = str.charAt(index++);
            switch (input) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                }
            }
        }
        return buffer.toString();
    }

    Token nextToken() {
        this.current = this.source.getNextToken();
        return this.current;
    }

    void nextItem(boolean nodeOnly) {
        Token t = this.nextToken();
        while (t.kind != 0) {
            if (t.kind == 24) {
                boolean isNode = t.image.equals("node");
                if (nodeOnly && isNode) {
                    return;
                }
                if (!nodeOnly && (isNode || t.image.equals("element"))) {
                    return;
                }
            }
            t = this.nextToken();
        }
    }

    void expectSemiColon() {
        boolean isBlock = this.current.kind == 30;
        Token t = this.nextToken();
        if (t.image.equals(";")) {
            this.nextToken();
        } else if (!isBlock) {
            this.printError("expecting the terminator ';'");
        }
    }

    Object parseValue() {
        Token t = this.current;
        switch (t.kind) {
            case 14: {
                return Boolean.TRUE;
            }
            case 15: {
                return Boolean.FALSE;
            }
            case 22: {
                return this.parseCharacterLiteral(t.image);
            }
            case 23: {
                return IlrPropertyParser.parseStringLiteral(t.image);
            }
            case 16: {
                return this.parseIntegerLiteral(t);
            }
            case 20: {
                return this.parseFloatLiteral(t);
            }
            case 29: {
                return this.parseArray();
            }
        }
        this.printError("expecting a valid value");
        return null;
    }

    Object[] parseArray() {
        Token t = this.current;
        if (t.kind != 29) {
            this.printError("expecting a starting of block with '{'");
            return null;
        }
        t = this.nextToken();
        Vector<Object> vect = new Vector<Object>(5);
        vect.addElement(this.parseValue());
        t = this.nextToken();
        while (t.image.equals(",")) {
            t = this.nextToken();
            vect.addElement(this.parseValue());
            t = this.nextToken();
        }
        if (t.kind != 30) {
            this.printError("expecting an end of block with '}'");
            return null;
        }
        int size = vect.size();
        Object[] arr = new Object[size];
        vect.copyInto(arr);
        return arr;
    }

    String parseName() {
        Token t = this.current;
        if (t.kind == 23) {
            this.nextToken();
            return t.image;
        }
        if (t.kind != 24) {
            this.printError("expecting a valid identifier");
            return null;
        }
        StringBuilder buffer = new StringBuilder(t.image);
        t = this.nextToken();
        while (t.kind == 35) {
            t = this.nextToken();
            if (t.kind != 24) {
                this.printError("expecting a valid identifier");
                return null;
            }
            buffer.append('.');
            buffer.append(t.image);
            t = this.nextToken();
        }
        return buffer.toString();
    }

    void parseElement() {
        String name = this.parseName();
        if (name == null) {
            this.nextItem(false);
            return;
        }
        if (this.current.kind == 39) {
            this.nextToken();
            this.addProperty(name, this.parseValue());
            this.expectSemiColon();
        } else {
            this.printError("expecting an assignment with '='");
        }
    }

    void parseNode() {
        block6: {
            block7: {
                String name = this.parseName();
                if (name == null) {
                    this.nextItem(true);
                    return;
                }
                this.enterNode(name);
                if (this.current.kind != 29) {
                    this.printError("expecting a block starting with '{'");
                    this.nextItem(true);
                    return;
                }
                this.nextToken();
                while (true) {
                    Token t = this.current;
                    if (t.kind == 0) {
                        this.printError("EOF encountered while parsing a node");
                        break block6;
                    }
                    if (t.kind == 30) {
                        this.expectSemiColon();
                        break block6;
                    }
                    if (t.kind != 24) break block7;
                    if (t.image.equals("element")) {
                        this.nextToken();
                        this.parseElement();
                        continue;
                    }
                    if (!t.image.equals("node")) break;
                    this.nextToken();
                    this.parseNode();
                }
                this.printError("expecting 'element' or 'node'");
                this.nextItem(false);
                return;
            }
            this.printError("expecting 'element' or 'node'");
            this.nextItem(false);
            return;
        }
        this.exitNode();
    }
}

