/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.resources;

import ilog.rules.util.resources.IlrPropertyParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public final class IlrResources
implements Serializable {
    private static final String NameProperty = "meta.name";
    private static final String SystemProperty = "ilog.rules.engine.config.file";
    private static final String TheFileName = "engine.conf";
    private Vector names;
    private Hashtable table;
    private transient IlrPropertyParser parser;
    private transient ClassLoader classLoader;

    public IlrResources() {
        this(true);
    }

    public IlrResources(boolean init) {
        this.names = new Vector();
        this.table = new Hashtable();
        this.parser = new IlrPropertyParser();
        if (init) {
            this.initResources();
        }
    }

    public IlrResources(Reader reader) {
        this.names = new Vector();
        this.table = new Hashtable();
        this.parser = new IlrPropertyParser();
        this.load(reader);
    }

    public IlrResources(IlrResources initial) {
        this.names = (Vector)initial.names.clone();
        this.table = (Hashtable)initial.table.clone();
        this.parser = new IlrPropertyParser();
        this.classLoader = initial.classLoader;
    }

    public InputStreamReader createReader(InputStream stream) throws UnsupportedEncodingException {
        String enc = this.getString("ilog.rules.engine.encoding", null);
        if (enc == null) {
            return new InputStreamReader(stream);
        }
        return new InputStreamReader(stream, enc);
    }

    public OutputStreamWriter createWriter(OutputStream stream) throws UnsupportedEncodingException {
        String enc = this.getString("ilog.rules.engine.encoding", null);
        if (enc == null) {
            return new OutputStreamWriter(stream);
        }
        return new OutputStreamWriter(stream, enc);
    }

    public InputStream getResourceAsStream(String name) {
        final String finalName = name;
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IlrResources.this.internalGetResourceAsStream(finalName);
            }
        });
    }

    private InputStream internalGetResourceAsStream(String name) {
        InputStream stream;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((stream = this.getClass().getClassLoader().getResourceAsStream(name)) == null && this.classLoader != null) {
            stream = this.classLoader.getResourceAsStream(name);
        }
        return stream;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    private void loadPrivatePackage() {
        InputStream stream = this.getResourceAsStream("/ilog/rules/engine/engine.conf");
        this.parsePrivatePackage(stream);
    }

    private void internalLoadPrivatePackage() {
        InputStream stream = this.internalGetResourceAsStream("/ilog/rules/engine/engine.conf");
        this.parsePrivatePackage(stream);
    }

    private void parsePrivatePackage(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, "ASCII");
            this.internalLoad(reader);
            ((Reader)reader).close();
            stream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void initResources() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IlrResources.this.internalLoadPrivatePackage();
                InputStream stream = IlrResources.this.internalGetResourceAsStream("/META-INF/engine.conf");
                if (stream != null) {
                    IlrResources.this.load(stream);
                } else {
                    try {
                        String filename = System.getProperty(IlrResources.SystemProperty);
                        if (filename == null) {
                            return null;
                        }
                        FileInputStream str = new FileInputStream(filename);
                        InputStreamReader reader = IlrResources.this.createReader(str);
                        IlrResources.this.internalLoad(reader);
                        ((InputStream)str).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.parser = new IlrPropertyParser();
    }

    public void clear() {
        this.names.clear();
        this.table.clear();
    }

    public void clearToDefaults() {
        this.clear();
        this.loadPrivatePackage();
    }

    public void putAll(IlrResources resources) {
        int len = resources.names.size();
        for (int i = 0; i < len; ++i) {
            String name = (String)resources.names.elementAt(i);
            if (this.names.contains(name)) continue;
            this.names.addElement(name);
        }
        this.table.putAll(resources.table);
    }

    public Set entrySet() {
        return this.table.entrySet();
    }

    private boolean internalLoad(Reader reader) throws IOException {
        boolean res = this.parser.parse(reader, this.table);
        String name = this.getString(NameProperty, null);
        if (name != null && !this.names.contains(name)) {
            this.names.add(name);
        }
        reader.close();
        return res;
    }

    public boolean load(Reader reader) {
        try {
            return this.internalLoad(reader);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean load(InputStream str) {
        try {
            InputStreamReader reader = this.createReader(str);
            boolean res = this.internalLoad(reader);
            str.close();
            return res;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean load(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            InputStreamReader reader = this.createReader(stream);
            boolean res = this.load(reader);
            stream.close();
            return res;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean forPackage(String pkg) {
        char[] a = pkg.toCharArray();
        int len = a.length;
        StringBuffer buffer = new StringBuffer(len + 20);
        if (a[0] != '/') {
            buffer.append('/');
        }
        for (int i = 0; i < len; ++i) {
            buffer.append(a[i] == '.' ? (char)'/' : a[i]);
        }
        if (a[len - 1] != '/') {
            buffer.append('/');
        }
        buffer.append(TheFileName);
        InputStream stream = this.getResourceAsStream(buffer.toString());
        if (stream == null) {
            return false;
        }
        return this.load(stream);
    }

    public boolean forClass(Class cl) {
        InputStream stream = cl.getResourceAsStream(TheFileName);
        if (stream == null) {
            return false;
        }
        return this.load(stream);
    }

    public boolean forObject(Object obj) {
        return this.forClass(obj.getClass());
    }

    public String[] getNames() {
        int size = this.names.size();
        Object[] arr = new String[size];
        this.names.copyInto(arr);
        return arr;
    }

    public String getName() {
        int size = this.names.size();
        return size == 0 ? null : (String)this.names.elementAt(size - 1);
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public Object get(String key, Object def) {
        Object val = this.table.get(key);
        return val == null ? def : val;
    }

    public Object[] getArray(String key, Object[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        Object[] arr = new Object[len];
        System.arraycopy(val, 0, arr, 0, len);
        return arr;
    }

    public String getString(String key, String def) {
        String val = (String)this.table.get(key);
        return val != null ? val : def;
    }

    public String[] getStringArray(String key, String[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        String[] arr = new String[len];
        System.arraycopy(val, 0, arr, 0, len);
        return arr;
    }

    public boolean getBoolean(String key, boolean def) {
        Boolean val = (Boolean)this.table.get(key);
        if (val == null) {
            return def;
        }
        return val;
    }

    public boolean[] getBooleanArray(String key, boolean[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        boolean[] arr = new boolean[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = val[i] == Boolean.TRUE;
        }
        return arr;
    }

    public char getChar(String key, char def) {
        Character val = (Character)this.table.get(key);
        return val != null ? val.charValue() : def;
    }

    public char[] getCharArray(String key, char[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        char[] arr = new char[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ((Character)val[i]).charValue();
        }
        return arr;
    }

    public int getInt(String key, int def) {
        Number val = (Number)this.table.get(key);
        return val != null ? val.intValue() : def;
    }

    public int[] getIntArray(String key, int[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ((Number)val[i]).intValue();
        }
        return arr;
    }

    public long getLong(String key, long def) {
        Number val = (Number)this.table.get(key);
        return val != null ? val.longValue() : def;
    }

    public long[] getLongArray(String key, long[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ((Number)val[i]).longValue();
        }
        return arr;
    }

    public float getFloat(String key, float def) {
        Number val = (Number)this.table.get(key);
        return val != null ? val.floatValue() : def;
    }

    public float[] getFloatArray(String key, float[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        float[] arr = new float[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ((Number)val[i]).floatValue();
        }
        return arr;
    }

    public double getDouble(String key, double def) {
        Number val = (Number)this.table.get(key);
        return val != null ? val.doubleValue() : def;
    }

    public double[] getDoubleArray(String key, double[] def) {
        Object[] val = (Object[])this.table.get(key);
        if (val == null) {
            return def;
        }
        int len = val.length;
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ((Number)val[i]).doubleValue();
        }
        return arr;
    }

    public Object remove(String key) {
        return this.table.remove(key);
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public void put(String key, Object value) {
        this.table.put(key, value);
    }

    public void putString(String key, String value) {
        this.table.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.table.put(key, value);
    }

    public void putChar(String key, char value) {
        this.table.put(key, Character.valueOf(value));
    }

    public void putInt(String key, int value) {
        this.table.put(key, value);
    }

    public void putLong(String key, long value) {
        this.table.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.table.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.table.put(key, value);
    }
}

