/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.xml.IlrPersistentObject;
import ilog.rules.util.xml.IlrXmlConstants;
import ilog.rules.util.xml.IlrXmlHandler;
import ilog.rules.util.xml.IlrXmlHandlerBase;
import ilog.rules.util.xml.IlrXmlHandlerClassException;
import ilog.rules.util.xml.IlrXmlSAXException;
import ilog.rules.util.xml.IlrXmlStorageManager;
import ilog.rules.util.xml.IlrXmlWriteException;
import ilog.rules.util.xml.IlrXmlWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrXmlObjectHandler
extends IlrXmlHandlerBase
implements IlrXmlConstants {
    private IlrPersistentObject xmlObject = null;
    protected StringBuffer buffer = null;
    private String propertyName = null;
    private String propertyType = null;
    private IlrXmlHandler parent = null;
    protected Locator locator = null;
    private Vector listeners;

    protected void fireInitializeObject(IlrPersistentObject object) {
        if (this.listeners != null) {
            XmlObjectEvent e = new XmlObjectEvent(object);
            Vector listeners = this.listeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((XmlObjectListener)listeners.elementAt(i)).initializeObject(e);
            }
        }
    }

    public void addXmlObjectListener(XmlObjectListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public IlrPersistentObject getPersistentObject() {
        return this.xmlObject;
    }

    public void setPersistentObject(IlrPersistentObject object) {
        this.xmlObject = object;
    }

    @Override
    public void writeObject(IlrXmlWriter writer, Object object, IlrXmlStorageManager manager) throws IlrXmlWriteException, IOException {
        this.startWriteObject(writer, object, manager);
        this.endWriteObject(writer, object, manager);
    }

    protected void startWriteObject(IlrXmlWriter writer, Object object, IlrXmlStorageManager manager) throws IlrXmlWriteException, IOException {
        this.xmlObject = (IlrPersistentObject)object;
        writer.printStartEmptyTag("ilr-xml-object");
        writer.printAttribute("class", this.xmlObject.getClass().getName());
        writer.printAttribute("version", this.xmlObject.getXmlVersion());
        writer.println(">");
        writer.incIndent();
        Enumeration names = this.xmlObject.getXmlPropertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object prop = this.xmlObject.getXmlProperty(name);
                if (prop == null) continue;
                if (prop instanceof String) {
                    writer.printStartEmptyTag("ilr-xml-property");
                    writer.printAttribute("name", name);
                    writer.printAttribute("type", "string");
                    writer.print(">");
                    writer.printCDATA((String)prop);
                    writer.beginDisableIndent();
                    writer.printEndTag("ilr-xml-property");
                    writer.endDisableIndent();
                    continue;
                }
                if (!(prop instanceof IlrPersistentObject)) continue;
                writer.printStartEmptyTag("ilr-xml-property");
                writer.printAttribute("name", name);
                writer.printAttribute("type", "object");
                writer.print(">");
                Class hClass = ((IlrPersistentObject)prop).getXmlHandlerClass();
                try {
                    writer.println("");
                    writer.incIndent();
                    manager.writeObject(writer, prop, manager.getHandler(hClass));
                    writer.decIndent();
                    writer.printEndTag("ilr-xml-property");
                }
                catch (IlrXmlHandlerClassException e) {
                    throw e.createWriteException();
                }
            }
        }
    }

    protected void endWriteObject(IlrXmlWriter writer, Object object, IlrXmlStorageManager manager) throws IlrXmlWriteException, IOException {
        writer.decIndent();
        writer.printEndTag("ilr-xml-object");
    }

    protected boolean checkVersion(String version) {
        return this.xmlObject.getXmlVersion().equals(version);
    }

    private String checkClassName(String oldClassName) {
        int index = oldClassName.lastIndexOf(46);
        String packName = oldClassName.substring(0, index);
        String restOfName = oldClassName.substring(index);
        if (packName.equals("ilog.rules.xml")) {
            packName = "ilog.rules.util.xml";
        }
        return packName + restOfName;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.buffer = null;
        if ("ilr-xml-object".equals(qName)) {
            String clsString = attributes.getValue("class");
            clsString = this.checkClassName(clsString);
            String version = attributes.getValue("version");
            if (clsString == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "class", this.locator, null);
            }
            try {
                Class hClass = this.getStorageManager().lookupClass(clsString, version);
                if (this.xmlObject == null) {
                    this.setPersistentObject((IlrPersistentObject)hClass.newInstance());
                } else if (!hClass.isInstance(this.xmlObject)) {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", clsString, this.locator, null);
                }
                if (!this.checkVersion(version)) {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectVersion", version, this.locator, null);
                }
                this.fireInitializeObject(this.xmlObject);
            }
            catch (ClassCastException e) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", clsString, this.locator, (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", clsString, this.locator, (Exception)e);
            }
            catch (InstantiationException e) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.BadObjectClass", clsString, this.locator, (Exception)e);
            }
            catch (ClassNotFoundException e) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoObjectClass", clsString, this.locator, (Exception)e);
            }
        } else if (this.xmlObject != null && "ilr-xml-property".equals(qName)) {
            this.propertyName = attributes.getValue("name");
            this.propertyType = attributes.getValue("type");
            if (this.propertyName == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "name", this.locator, null);
            }
            if (this.propertyType == null) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "type", this.locator, null);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!"ilr-xml-object".equals(qName) && "ilr-xml-property".equals(qName) && this.propertyName != null && this.buffer != null && "string".equals(this.propertyType)) {
            this.xmlObject.addXmlProperty(this.propertyName, this.buffer.toString());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(length);
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void reset() {
        this.xmlObject = null;
        this.propertyName = null;
        this.propertyType = null;
    }

    @Override
    public void deactivate(IlrXmlHandler parent) throws SAXException {
        this.parent = parent;
        this.xmlObject = null;
        this.buffer = null;
        this.propertyName = null;
        this.propertyType = null;
        this.locator = null;
    }

    @Override
    public void childProcessed(IlrXmlHandler child) throws SAXException {
        if (child instanceof IlrXmlObjectHandler && "object".equals(this.propertyType)) {
            this.xmlObject.addXmlProperty(this.propertyName, ((IlrXmlObjectHandler)child).getPersistentObject());
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.parent == null) {
            Object[] args = new String[]{exception.getPublicId(), "" + exception.getLineNumber(), "" + exception.getColumnNumber()};
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.ParseError", args, null, (Exception)exception);
        }
        this.parent.fatalError(exception);
    }

    @Override
    public Object getData() {
        return this.getPersistentObject();
    }

    public static interface XmlObjectListener
    extends EventListener {
        public void initializeObject(XmlObjectEvent var1);
    }

    public class XmlObjectEvent
    extends EventObject {
        public XmlObjectEvent(IlrPersistentObject object) {
            super(object);
        }
    }
}

