/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client.internal;

import com.sinosoft.image.client.internal.ResponseMessage;
import com.sinosoft.image.exception.ImgClientException;
import com.sinosoft.image.exception.ImgErrorCode;
import com.sinosoft.image.exception.ImgServiceException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseMessageBuilder {
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpURLConnection conn = null;
    private int statusCode;
    private String message;
    private Object[] contentObjs;
    private byte[] contentByte;
    private String contentJson;

    public ResponseMessageBuilder(HttpURLConnection conn) {
        this.conn = conn;
    }

    public ResponseMessageBuilder parseHeaders() {
        Map<String, List<String>> map = this.conn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            this.headers.put(entry.getKey(), values.get(0));
        }
        return this;
    }

    public ResponseMessageBuilder parseStatus() {
        try {
            this.statusCode = this.conn.getResponseCode();
            if (this.statusCode == 500 && this.message == null) {
                this.message = this.headers.get("ErrorMsg");
            }
        }
        catch (IOException e) {
            this.statusCode = 500;
            throw new ImgServiceException(ImgErrorCode.IOException, (Throwable)e);
        }
        return this;
    }

    public ResponseMessageBuilder parseResultObject() {
        block13: {
            ObjectInputStream inStream = null;
            try {
                try {
                    inStream = new ObjectInputStream(this.conn.getInputStream());
                    Integer statusCode = (Integer)inStream.readObject();
                    this.message = (String)inStream.readObject();
                    if (statusCode == 200) {
                        ArrayList<Object> objList = new ArrayList<Object>();
                        Object obj = inStream.readObject();
                        while (obj != null) {
                            objList.add(obj);
                            obj = inStream.readObject();
                            if ("END".equals(obj)) break;
                        }
                        this.contentObjs = objList.toArray();
                        break block13;
                    }
                    this.statusCode = 500;
                    throw new ImgServiceException(this.message);
                }
                catch (ClassNotFoundException e) {
                    throw new ImgClientException(e.getMessage());
                }
                catch (IOException e) {
                    throw new ImgServiceException(ImgErrorCode.IOException, (Throwable)e);
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this;
    }

    public ResponseMessageBuilder parseResultByte() {
        if (this.statusCode == 500) {
            throw new ImgServiceException(this.message);
        }
        FilterInputStream input = null;
        this.contentByte = null;
        try {
            try {
                input = new DataInputStream(this.conn.getInputStream());
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byte[] b = new byte[8192];
                int read = 0;
                while ((read = ((DataInputStream)input).read(b)) != -1) {
                    byteOut.write(b, 0, read);
                }
                this.contentByte = byteOut.toByteArray();
            }
            catch (IOException e) {
                throw new ImgServiceException(ImgErrorCode.IOException, (Throwable)e);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    public ResponseMessageBuilder parseResultJson() {
        if (this.statusCode == 500) {
            throw new ImgServiceException(this.message);
        }
        FilterInputStream input = null;
        this.contentJson = null;
        try {
            try {
                input = new DataInputStream(this.conn.getInputStream());
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byte[] b = new byte[8192];
                int read = 0;
                while ((read = ((DataInputStream)input).read(b)) != -1) {
                    byteOut.write(b, 0, read);
                }
                this.contentJson = new String(byteOut.toByteArray(), "utf-8");
            }
            catch (IOException e) {
                throw new ImgServiceException(ImgErrorCode.IOException, (Throwable)e);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    public ResponseMessage build() {
        ResponseMessage responseMsg = new ResponseMessage();
        responseMsg.setStatusCode(this.statusCode);
        responseMsg.setContentObjs(this.contentObjs);
        responseMsg.setContentByte(this.contentByte);
        responseMsg.setContentJson(this.contentJson);
        responseMsg.setMessage(this.message);
        responseMsg.setHeaders(this.headers);
        responseMsg.setResponeTime(new Date());
        return responseMsg;
    }
}

