/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.client.utils;

import com.sinosoft.image.exception.ImgClientException;
import com.sinosoft.image.exception.ImgErrorCode;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class ImgIOUtils {
    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        String result;
        if (in == null) {
            return "";
        }
        Reader reader = null;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n = -1;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            result = ((Object)writer).toString();
        }
        finally {
            in.close();
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        return result;
    }

    public static byte[] readStreamAsByteArray(InputStream inputStream) {
        byte[] data = null;
        if (inputStream == null) {
            return data;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        try {
            try {
                int read = 0;
                while ((read = inputStream.read(b)) > 0) {
                    byteOut.write(b, 0, read);
                }
                data = byteOut.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                inputStream.close();
                byteOut.close();
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean checkFile(File file) {
        if (file == null) {
            return false;
        }
        boolean exists = false;
        boolean isFile = false;
        boolean canRead = false;
        try {
            exists = file.exists();
            isFile = file.isFile();
            canRead = file.canRead();
        }
        catch (SecurityException se) {
            return false;
        }
        return exists && isFile && canRead;
    }

    public static byte[] readFileAsByteArray(File file) {
        FileInputStream is = null;
        byte[] result = null;
        try {
            is = new FileInputStream(file);
            result = null;
            result = is == null || ((InputStream)is).available() < 1 ? new byte[]{} : ImgIOUtils.readStreamAsByteArray(is);
        }
        catch (FileNotFoundException e) {
            throw new ImgClientException(ImgErrorCode.FileNotFound, file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ImgClientException(file.getAbsolutePath(), ImgErrorCode.IOException, e);
        }
        ImgIOUtils.safeClose(is);
        return result;
    }

    public static byte[] readUrlAsByteArray(String address) throws IOException {
        URL url = null;
        byte[] fileData = null;
        InputStream inputStream = null;
        try {
            try {
                url = new URL(address);
                inputStream = url.openStream();
                fileData = ImgIOUtils.readStreamAsByteArray(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("readURL ERROR:" + address, e);
            }
        }
        catch (Throwable throwable) {
            ImgIOUtils.safeClose(inputStream);
            throw throwable;
        }
        ImgIOUtils.safeClose(inputStream);
        return fileData;
    }

    public static byte[] streamToByte(InputStream inputStream) {
        byte[] data = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        try {
            try {
                int read = 0;
                while ((read = inputStream.read(b)) > 0) {
                    byteOut.write(b, 0, read);
                }
                data = byteOut.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                inputStream.close();
                byteOut.close();
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    public static void streamToFile(InputStream inputStream, File file) {
        FileOutputStream outStream = null;
        byte[] buffer = new byte[8192];
        try {
            try {
                int bytesRead;
                outStream = new FileOutputStream(file);
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("\u8bf7\u68c0\u67e5" + file.getAbsolutePath() + "\u662f\u5426\u5b58\u5728", e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                inputStream.close();
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void byteToFile(byte[] inputByte, File file) {
        FileOutputStream outStream = null;
        try {
            try {
                outStream = new FileOutputStream(file);
                ((OutputStream)outStream).write(inputByte);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("\u8bf7\u68c0\u67e5" + file.getAbsolutePath() + "\u662f\u5426\u5b58\u5728", e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

