/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.image.exception;

import com.sinosoft.image.exception.ImgErrorCode;
import java.text.MessageFormat;

public class ImgClientException
extends RuntimeException {
    private static final long serialVersionUID = 1870835486798448798L;
    private String errorMessage;
    private ImgErrorCode errorCode;

    public ImgClientException(String errorMessage) {
        this(errorMessage, ImgErrorCode.Other);
    }

    public ImgClientException(ImgErrorCode errorCode, Object ... args) {
        this(MessageFormat.format(errorCode.getErrorDesc(), args), errorCode);
    }

    public ImgClientException(String errorMessage, ImgErrorCode errorCode) {
        super(errorMessage);
        if (errorCode == null) {
            errorCode = ImgErrorCode.Other;
        }
        if (errorMessage == null) {
            errorMessage = errorCode.getErrorDesc();
        }
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ImgClientException(String errorMessage, Throwable cause) {
        this(errorMessage, null, cause);
    }

    public ImgClientException(ImgErrorCode errorCode, Throwable cause) {
        this(cause.getMessage(), errorCode, cause);
    }

    public ImgClientException(String errorMessage, ImgErrorCode errorCode, Throwable cause) {
        super(errorMessage, cause);
        if (errorCode == null) {
            errorCode = ImgErrorCode.Unknown;
        }
        if (errorMessage == null) {
            errorMessage = errorCode.getErrorDesc();
        }
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ImgErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return String.format(String.valueOf(this.errorMessage) + "(%s:%d)", this.errorCode.name(), this.errorCode.getErrorCode());
    }
}

