/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class CacheManager {
    private static Log logger = LogFactory.getLog(CacheManager.class);
    private static Map<String, Object> allCacheMap = new HashMap<String, Object>(0);
    private Map<String, Object> cacheMap = new HashMap<String, Object>(0);
    private String cacheName;
    private Object lockObject = new Object();

    private CacheManager(String cacheName) {
        this.cacheName = cacheName;
    }

    public static void main(String[] args) {
    }

    public static CacheManager getIntance(String cacheName) {
        if (allCacheMap.containsKey(cacheName)) {
            return (CacheManager)allCacheMap.get(cacheName);
        }
        CacheManager cacheManager = new CacheManager(cacheName);
        allCacheMap.put(cacheName, cacheManager);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create cacheManager " + cacheName));
        }
        return cacheManager;
    }

    public static String[] getAllCacheName() {
        Object[] keyArray = allCacheMap.keySet().toArray();
        String[] nameArray = new String[keyArray.length];
        int i = 0;
        while (i < keyArray.length) {
            nameArray[i] = (String)keyArray[i];
            ++i;
        }
        return nameArray;
    }

    public static synchronized void clearAllCacheManager() {
        String[] cacheNameArray = CacheManager.getAllCacheName();
        int i = 0;
        while (i < cacheNameArray.length) {
            CacheManager.getIntance(cacheNameArray[i]).clearCache(new Object[0]);
            ++i;
        }
    }

    public Object getCache(String key) {
        Object value = this.cacheMap.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieve data key=" + key + ",value=" + value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCache(String key, Object value) {
        Object object = this.lockObject;
        synchronized (object) {
            this.cacheMap.put(key, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put cache key=" + key + ",value=" + value));
            }
        }
    }

    public synchronized void clearCache(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            int size = this.cacheMap.size();
            this.cacheMap.clear();
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Clear " + this.cacheName + " total " + size + " item(s)."));
            }
            return;
        }
        String keyPrefix = this.generateKey(arguments);
        String keyName = "";
        Object[] keys = this.cacheMap.keySet().toArray();
        int size = 0;
        int i = 0;
        while (i < keys.length) {
            keyName = (String)keys[i];
            if (keyName != null && keyName.startsWith(keyPrefix)) {
                this.cacheMap.remove(keyName);
                ++size;
            }
            ++i;
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Clear " + this.cacheName + " " + size + " item(s).prefix=" + keyPrefix));
        }
    }

    public boolean containsKey(String key) {
        return this.cacheMap.containsKey(key);
    }

    public boolean containsValue(String value) {
        return this.cacheMap.containsValue(value);
    }

    public String generateCacheKey(Object ... arguments) {
        Assert.isTrue((arguments != null ? 1 : 0) != 0);
        Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0);
        return this.generateKey(arguments);
    }

    private String generateKey(Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arguments.length) {
            sb.append(".").append(arguments[i]);
            ++i;
        }
        return sb.toString();
    }
}

