/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.rule;

import ins.framework.rule.RuleService;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.PackageDescr;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsRuleServiceImpl
implements BeanNameAware,
ResourceLoaderAware,
RuleService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String beanName;
    private Resource dslFile;
    private ResourceLoader resourceLoader;
    private RuleBase ruleBase;
    private String[] ruleFiles;

    private void assertObject(WorkingMemory workingMemory, Object element) {
        if (element == null) {
            return;
        }
        FactHandle fact = workingMemory.getFactHandle(element);
        if (fact == null) {
            workingMemory.assertObject(element);
        } else {
            workingMemory.modifyObject(fact, element);
        }
    }

    private RuleBase getRuleBase() {
        if (this.ruleBase == null) {
            try {
                this.compileRuleBase();
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.ruleBase;
    }

    private synchronized void compileRuleBase() throws Exception {
        if (this.ruleBase != null) {
            return;
        }
        PackageBuilder builder = new PackageBuilder();
        this.ruleBase = RuleBaseFactory.newRuleBase();
        if (this.ruleFiles != null) {
            InputStreamReader dslReader = null;
            if (this.dslFile != null) {
                dslReader = new InputStreamReader(this.dslFile.getInputStream(), "UTF-8");
            }
            ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
            String[] stringArray = this.ruleFiles;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                Resource[] rules;
                String rulePattern = stringArray[n];
                Resource[] resourceArray = rules = resolver.getResources(rulePattern);
                int n3 = 0;
                int n4 = resourceArray.length;
                while (n3 < n4) {
                    Resource ruleFile = resourceArray[n3];
                    InputStreamReader drlReader = new InputStreamReader(ruleFile.getInputStream(), "UTF-8");
                    PackageDescr packageDescr = this.dslFile != null ? new DrlParser().parse((Reader)drlReader, (Reader)dslReader) : new DrlParser().parse((Reader)drlReader);
                    builder.addPackage(packageDescr);
                    ++n3;
                }
                ++n;
            }
            this.ruleBase.addPackage(builder.getPackage());
        } else {
            this.logger.warn((Object)("DroolsTemplate" + this.beanName + "didn't set the rule files"));
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setDslFile(Resource dslFile) {
        this.dslFile = dslFile;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setRuleFiles(String[] ruleFiles) {
        this.ruleFiles = ruleFiles;
    }

    @Override
    public Object executeRules(String name, Object object, String URL2) {
        WorkingMemory wm = this.getRuleBase().newWorkingMemory();
        this.assertObject(wm, object);
        wm.fireAllRules();
        return object;
    }

    @Override
    public Map executeRules(Map<String, Object> map, String URL2) {
        WorkingMemory wm = this.getRuleBase().newWorkingMemory();
        for (Object object : map.values()) {
            this.assertObject(wm, object);
        }
        wm.fireAllRules();
        return map;
    }
}

