/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.security;

import ins.framework.cache.CacheManager;
import java.util.Iterator;
import javax.sql.DataSource;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.ConfigAttributeEditor;
import org.acegisecurity.intercept.method.MethodDefinitionSource;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class DBMethodDefinitionSource
implements MethodDefinitionSource {
    private static CacheManager cacheManager = CacheManager.getIntance("MethodDefinitionSource");
    private DataSource dataSource;
    private String authsByResourceQuery;
    private ConfigAttributeDefinition anonymouslyDefinition;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAuthsByResourceQuery(String authsByResourceQuery) {
        this.authsByResourceQuery = authsByResourceQuery;
    }

    public DBMethodDefinitionSource() {
        ConfigAttributeEditor configAttrEditor = new ConfigAttributeEditor();
        configAttrEditor.setAsText("IS_AUTHENTICATED_ANONYMOUSLY");
        this.anonymouslyDefinition = (ConfigAttributeDefinition)configAttrEditor.getValue();
    }

    public ConfigAttributeDefinition getAttributes(Object object) {
        MethodInvocation miv = (MethodInvocation)object;
        String methodName = miv.getMethod().getName();
        if (methodName.startsWith("set") || methodName.startsWith("get") || methodName.equals("validate") || methodName.equals("hasErrors")) {
            return this.anonymouslyDefinition;
        }
        String s_method = String.valueOf(miv.getThis().getClass().getName()) + "." + methodName;
        String key = cacheManager.generateCacheKey(s_method);
        Object result = cacheManager.getCache(key);
        if (result != null) {
            return (ConfigAttributeDefinition)result;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        StringBuffer auths = new StringBuffer();
        Object[] args = new String[]{s_method};
        SqlRowSet rowSet = jdbcTemplate.queryForRowSet(this.authsByResourceQuery, args);
        while (rowSet.next()) {
            auths.append(rowSet.getString(1));
            auths.append(",");
        }
        String s_auths = auths.toString();
        if (s_auths.length() > 0) {
            s_auths = s_auths.substring(0, s_auths.length() - 1);
        }
        if (s_auths.equals("")) {
            s_auths = "IS_AUTHENTICATED_ANONYMOUSLY";
        }
        ConfigAttributeEditor configAttrEditor = new ConfigAttributeEditor();
        configAttrEditor.setAsText(s_auths);
        ConfigAttributeDefinition configAttributeDefinition = (ConfigAttributeDefinition)configAttrEditor.getValue();
        cacheManager.putCache(key, configAttributeDefinition);
        return configAttributeDefinition;
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz) || JoinPoint.class.isAssignableFrom(clazz);
    }

    public Iterator getConfigAttributeDefinitions() {
        return null;
    }
}

