/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils
extends org.apache.commons.beanutils.BeanUtils {
    protected static final Log logger = LogFactory.getLog(BeanUtils.class);

    private BeanUtils() {
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        Assert.notNull((Object)object);
        Assert.hasText((String)propertyName);
        return BeanUtils.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class clazz, String propertyName) throws NoSuchFieldException {
        Assert.notNull((Object)clazz);
        Assert.hasText((String)propertyName);
        Class superClass = clazz;
        while (superClass != Object.class) {
            try {
                return superClass.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                superClass = superClass.getSuperclass();
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        Assert.notNull((Object)object);
        Assert.hasText((String)propertyName);
        Field field = BeanUtils.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.info((Object)"error wont' happen");
        }
        field.setAccessible(accessible);
        return result;
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        Assert.notNull((Object)object);
        Assert.hasText((String)propertyName);
        Field field = BeanUtils.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            logger.info((Object)"Error won't happen");
        }
        field.setAccessible(accessible);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        Assert.notNull((Object)object);
        Assert.hasText((String)methodName);
        Class[] types = new Class[params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = params[i].getClass();
            ++i;
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        Class<?> superClass = clazz;
        while (superClass != Object.class) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                superClass = superClass.getSuperclass();
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static List<Field> getFieldsByType(Object object, Class type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fieldArray = fields = object.getClass().getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field field = fieldArray[n];
            if (field.getType().isAssignableFrom(type)) {
                list.add(field);
            }
            ++n;
        }
        return list;
    }

    public static Class getPropertyType(Class type, String name) throws NoSuchFieldException {
        return BeanUtils.getDeclaredField(type, name).getType();
    }

    public static String getGetterName(Class type, String fieldName) {
        Assert.notNull((Object)type, (String)"Type required");
        Assert.hasText((String)fieldName, (String)"FieldName required");
        if (type.getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    public static Method getGetterMethod(Class type, String fieldName) {
        try {
            return type.getMethod(BeanUtils.getGetterName(type, fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object invoke(String className, String methodName, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> cl = Class.forName(className);
        Method method = cl.getMethod(methodName, argsClass);
        return method.invoke(cl.newInstance(), args);
    }

    public static Object invoke(Object oldObject, String methodName, Class[] argsClass, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = oldObject.getClass();
        Method method = cl.getMethod(methodName, argsClass);
        return method.invoke(oldObject, args);
    }

    public static String[] getFieldsName(Class cl) throws Exception {
        Field[] fields = cl.getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldNames[i] = fields[i].getName();
            ++i;
        }
        return fieldNames;
    }

    public static List<String> getAllFieldName(Class cl) {
        ArrayList<String> list = new ArrayList<String>();
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!field.getName().equals("serialVersionUID")) {
                list.add(field.getName());
            }
            ++i;
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(BeanUtils.getAllFieldName(cl));
        }
        return list;
    }

    public static List<Method> getSetter(Class cl) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = cl.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                list.add(method);
            }
            ++i;
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(BeanUtils.getSetter(cl));
        }
        return list;
    }

    public static List<Method> getGetter(Class cl) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = cl.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                list.add(method);
            }
            ++i;
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(BeanUtils.getGetter(cl));
        }
        return list;
    }

    public static String getClassNameWithoutPackage(Class cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        String name = className.substring(pos);
        return name;
    }

    public static String beanToString(Object obj) {
        return ToStringBuilder.reflectionToString((Object)obj);
    }
}

