/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private StringUtils() {
    }

    public static String newString(String value, int length) {
        StringBuffer buffer = new StringBuffer();
        if (value == null) {
            return null;
        }
        int i = 0;
        while (i < length) {
            buffer.append(value);
            ++i;
        }
        return buffer.toString();
    }

    public static String newString(char ch, int length) {
        return StringUtils.newString(String.valueOf(ch), length);
    }

    public static String copyString(String str, int copyTimes) {
        StringBuffer buffer = new StringBuffer();
        if (str == null) {
            return null;
        }
        int i = 0;
        while (i < copyTimes) {
            buffer.append(str);
            ++i;
        }
        return buffer.toString();
    }

    public static int getBytesLength(String str) {
        if (str == null) {
            return -1;
        }
        return str.getBytes().length;
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOf(String str, String subStr, int startIndex, int occurrenceTimes) {
        foundCount = 0;
        index = startIndex;
        substrLength = subStr.length();
        if (occurrenceTimes <= 0) {
            return -1;
        }
        if (str.length() - 1 < startIndex) {
            return -1;
        }
        if (!subStr.equals("")) ** GOTO lbl14
        return 0;
lbl-1000:
        // 1 sources

        {
            if ((index = str.indexOf(subStr, index)) == -1) {
                return -1;
            }
            ++foundCount;
            index += substrLength;
lbl14:
            // 2 sources

            ** while (foundCount < occurrenceTimes)
        }
lbl15:
        // 1 sources

        return index - substrLength;
    }

    public static int indexOf(String str, String subStr, int occurrenceTimes) {
        return StringUtils.indexOf(str, subStr, 0, occurrenceTimes);
    }

    public static int indexOf(String str, String subStr, int fromIndex, boolean caseSensitive) {
        if (!caseSensitive) {
            return str.toLowerCase().indexOf(subStr.toLowerCase(), fromIndex);
        }
        return str.indexOf(subStr, fromIndex);
    }

    public static String replace(String str, String searchStr, String replaceStr, boolean caseSensitive) {
        String result = "";
        int i = 0;
        int j = 0;
        if (str == null) {
            return null;
        }
        if (str.equals("")) {
            return "";
        }
        if (searchStr == null || searchStr.equals("")) {
            return str;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        while ((j = StringUtils.indexOf(str, searchStr, i, caseSensitive)) > -1) {
            result = String.valueOf(result) + str.substring(i, j) + replaceStr;
            i = j + searchStr.length();
        }
        result = String.valueOf(result) + str.substring(i, str.length());
        return result;
    }

    public static String replace(String str, String searchStr, String replaceStr) {
        return StringUtils.replace(str, searchStr, replaceStr, true);
    }

    public static String replace(String str, char searchChar, String replaceStr) {
        return StringUtils.replace(str, String.valueOf(searchChar), replaceStr, true);
    }

    public static String replace(String str, int beginIndex, String replaceStr) {
        String result = null;
        if (str == null) {
            return null;
        }
        if (replaceStr == null) {
            replaceStr = "";
        }
        result = String.valueOf(str.substring(0, beginIndex)) + replaceStr + str.substring(beginIndex + replaceStr.length());
        return result;
    }

    public static String[] split(String originalString, int splitByteLength) {
        ArrayList<String> list = new ArrayList<String>();
        String strText = "";
        byte[] arrByte = null;
        int intStartIndex = 0;
        int intEndIndex = 0;
        int index = 0;
        int fixCount = 0;
        String[] arrReturn = null;
        if (originalString == null) {
            return new String[0];
        }
        if (originalString.equals("")) {
            return new String[0];
        }
        if (originalString.trim().equals("")) {
            return new String[]{""};
        }
        if (splitByteLength <= 1) {
            return new String[]{originalString};
        }
        arrByte = originalString.getBytes();
        intEndIndex = 0;
        while (true) {
            intStartIndex = intEndIndex;
            intEndIndex = intStartIndex + splitByteLength;
            if (intStartIndex >= arrByte.length) break;
            if (intEndIndex > arrByte.length) {
                intEndIndex = arrByte.length;
                strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
                list.add(strText);
                break;
            }
            fixCount = 0;
            strText = new String(arrByte, intStartIndex, intEndIndex - intStartIndex);
            byte[] bytes = strText.getBytes();
            if (bytes.length < splitByteLength) {
                intEndIndex = intStartIndex + bytes.length;
            }
            index = intEndIndex - 1;
            while (index >= intStartIndex) {
                if (arrByte[index] == bytes[index - intStartIndex]) break;
                ++fixCount;
                --index;
            }
            if (fixCount > 0) {
                if (fixCount >= intEndIndex) {
                    fixCount = 0;
                    System.out.println("split length " + splitByteLength + " is too small.");
                }
                strText = new String(arrByte, intStartIndex, (intEndIndex -= fixCount) - intStartIndex);
            }
            list.add(strText);
        }
        arrReturn = new String[list.size()];
        list.toArray(arrReturn);
        return arrReturn;
    }

    public static String[] split(String originalString, String delimiterString) {
        int index = 0;
        String[] returnArray = null;
        int length = 0;
        if (originalString == null || delimiterString == null || originalString.equals("")) {
            return new String[0];
        }
        if (originalString.equals("") || delimiterString.equals("") || originalString.length() < delimiterString.length()) {
            return new String[]{originalString};
        }
        String strTemp = originalString;
        while (strTemp != null && !strTemp.equals("")) {
            index = strTemp.indexOf(delimiterString);
            if (index == -1) break;
            ++length;
            strTemp = strTemp.substring(index + delimiterString.length());
        }
        returnArray = new String[++length];
        int i = 0;
        while (i < length - 1) {
            index = originalString.indexOf(delimiterString);
            returnArray[i] = originalString.substring(0, index);
            originalString = originalString.substring(index + delimiterString.length());
            ++i;
        }
        returnArray[length - 1] = originalString;
        return returnArray;
    }

    public static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        int i = length - 1;
        while (i >= 0) {
            if (str.charAt(i) != ' ') break;
            --length;
            --i;
        }
        return str.substring(0, length);
    }

    public static String leftTrim(String str) {
        if (str == null) {
            return "";
        }
        int start = 0;
        int i = 0;
        int n = str.length();
        while (i < n) {
            if (str.charAt(i) != ' ') break;
            ++start;
            ++i;
        }
        return str.substring(start);
    }

    public static String absoluteTrim(String str) {
        String result = StringUtils.replace(str, " ", "");
        return result;
    }

    public static String lowerCase(String str, int beginIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toLowerCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String upperCase(String str, int beginIndex, int endIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(str.substring(0, beginIndex));
        buffer.append(str.substring(beginIndex, endIndex).toUpperCase());
        buffer.append(str.substring(endIndex));
        return buffer.toString();
    }

    public static String lowerCaseFirstChar(String iString) {
        String newString = String.valueOf(iString.substring(0, 1).toLowerCase()) + iString.substring(1);
        return newString;
    }

    public static String upperCaseFirstChar(String iString) {
        String newString = String.valueOf(iString.substring(0, 1).toUpperCase()) + iString.substring(1);
        return newString;
    }

    public static int timesOf(String str, String subStr) {
        int foundCount = 0;
        if (subStr.equals("")) {
            return 0;
        }
        int fromIndex = str.indexOf(subStr);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(subStr, fromIndex + subStr.length());
        }
        return foundCount;
    }

    public static int timesOf(String str, char ch) {
        int foundCount = 0;
        int fromIndex = str.indexOf(ch);
        while (fromIndex != -1) {
            ++foundCount;
            fromIndex = str.indexOf(ch, fromIndex + 1);
        }
        return foundCount;
    }

    public static Map<String, String> toMap(String str, String splitString) {
        Map<String, String> map = Collections.synchronizedMap(new HashMap());
        String[] values = StringUtils.split(str, splitString);
        int i = 0;
        while (i < values.length) {
            String tempValue = values[i];
            int pos = tempValue.indexOf("=");
            String key = "";
            String value = "";
            if (pos > -1) {
                key = tempValue.substring(0, pos);
                value = tempValue.substring(pos + splitString.length());
            } else {
                key = tempValue;
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public static String native2ascii(String str) {
        char[] ca = str.toCharArray();
        StringBuffer buffer = new StringBuffer(ca.length * 6);
        int x = 0;
        while (x < ca.length) {
            char a = ca[x];
            if (a > '\u00ff') {
                buffer.append("\\u").append(Integer.toHexString(a));
            } else {
                buffer.append(a);
            }
            ++x;
        }
        return buffer.toString();
    }
}

