/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.validator;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.ValidatorContext;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class MulLineFieldValidator
extends FieldValidatorSupport {
    private String context;
    private boolean appendPrefix = true;

    public void setAppendPrefix(boolean appendPrefix) {
        this.appendPrefix = appendPrefix;
    }

    public boolean isAppendPrefix() {
        return this.appendPrefix;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void validate(Object object) throws ValidationException {
        String visitorContext;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            this.log.warn((Object)"The visited object is null, VisitorValidator will not be able to handle validation properly. Please make sure the visited object is not null for VisitorValidator to function properly");
            return;
        }
        ValueStack stack = ActionContext.getContext().getValueStack();
        stack.push(object);
        String string = visitorContext = this.context == null ? ActionContext.getContext().getName() : this.context;
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            Object[] array = coll.toArray();
            this.validateArrayElements(object, array, fieldName, visitorContext);
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.validateArrayElements(object, array, fieldName, visitorContext);
        } else {
            this.validateSubObjectFields(object, value, fieldName, visitorContext);
            this.validateObject(fieldName, value, visitorContext);
        }
        stack.pop();
    }

    private void validateArrayElements(Object parent, Object[] array, String fieldName, String visitorContext) throws ValidationException {
        if (array == null) {
            return;
        }
        int i = 0;
        while (i < array.length) {
            Object o = array[i];
            if (o != null) {
                this.validateSubObjectFields(parent, o, String.valueOf(fieldName) + "[" + i + "]", visitorContext);
                this.validateObject(String.valueOf(fieldName) + "[" + i + "]", o, visitorContext);
            }
            ++i;
        }
    }

    private void validateSubObjectFields(Object parent, Object o, String fieldName, String visitorContext) throws ValidationException {
        Method[] methods;
        if (o == null) {
            return;
        }
        Method[] methodArray = methods = o.getClass().getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method method = methodArray[n];
            if (method.getName().startsWith("get") && method.getName().length() > 3) {
                Object subObj;
                String subFieldName = method.getName().substring(3);
                subFieldName = String.valueOf(subFieldName.substring(0, 1).toLowerCase()) + subFieldName.substring(1);
                String methodReturnType = method.getReturnType().getName();
                if (methodReturnType.equals("java.util.List")) {
                    subObj = null;
                    try {
                        subObj = (List)method.invoke(o, new Object[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (subObj != null && subObj != parent) {
                        Object[] objs = subObj.toArray();
                        this.validateArrayElements(o, objs, String.valueOf(fieldName) + "." + subFieldName, visitorContext);
                    }
                } else if (!(methodReturnType.equals("java.lang.String") || methodReturnType.equals("java.lang.Integer") || methodReturnType.equals("java.lang.Long") || methodReturnType.equals("java.math.BigDecimal") || methodReturnType.equals("java.util.Date") || methodReturnType.equals("java.lang.Class"))) {
                    subObj = null;
                    try {
                        subObj = method.invoke(o, new Object[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (subObj != null && subObj != parent) {
                        this.validateSubObjectFields(o, subObj, String.valueOf(fieldName) + "." + subFieldName, visitorContext);
                        this.validateObject(String.valueOf(fieldName) + "." + subFieldName, subObj, visitorContext);
                    }
                }
            }
            ++n;
        }
    }

    private void validateObject(String fieldName, Object o, String visitorContext) throws ValidationException {
        AppendingValidatorContext validatorContext;
        ValueStack stack = ActionContext.getContext().getValueStack();
        stack.push(o);
        if (this.appendPrefix) {
            validatorContext = new AppendingValidatorContext(this.getValidatorContext(), o, fieldName, this.getMessage(o));
        } else {
            ValidatorContext parent = this.getValidatorContext();
            validatorContext = new DelegatingValidatorContext((ValidationAware)parent, DelegatingValidatorContext.makeTextProvider((Object)o, (LocaleProvider)parent), (LocaleProvider)parent);
        }
        ActionValidatorManagerFactory.getInstance().validate(o, visitorContext, (ValidatorContext)validatorContext);
        stack.pop();
    }

    private class AppendingValidatorContext
    extends DelegatingValidatorContext {
        protected Object o;
        protected String field;
        protected String message;

        public AppendingValidatorContext(ValidatorContext parent, Object object, String field, String message) {
            super((ValidationAware)parent, AppendingValidatorContext.makeTextProvider((Object)object, (LocaleProvider)parent), (LocaleProvider)parent);
            this.field = field;
            this.message = message;
        }

        public String getFullFieldName(String fieldName) {
            return String.valueOf(this.field) + "." + fieldName;
        }

        public void addActionError(String anErrorMessage) {
            super.addFieldError(this.field, String.valueOf(this.message) + anErrorMessage);
        }

        public void addFieldError(String fieldName, String errorMessage) {
            super.addFieldError(this.getFullFieldName(fieldName), String.valueOf(this.message) + errorMessage);
        }
    }
}

