/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.validator;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

public class StringLengthFieldValidator
extends FieldValidatorSupport {
    private boolean doTrim = true;
    private int maxLength = -1;
    private int minLength = -1;

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setTrim(boolean trim) {
        this.doTrim = trim;
    }

    public boolean getTrim() {
        return this.doTrim;
    }

    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        String val = (String)this.getFieldValue(fieldName, object);
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.doTrim && (val = val.trim()).length() <= 0) {
            return;
        }
        int len = val.getBytes().length;
        if (this.minLength > -1 && len < this.minLength) {
            this.addFieldError(fieldName, object);
        } else if (this.maxLength > -1 && len > this.maxLength) {
            this.addFieldError(fieldName, object);
        }
    }
}

