/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web;

import ins.framework.utils.StringUtils;
import ins.framework.web.GZIPResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressFilter
implements Filter {
    private String[] ignoreKeys;
    private int ignoreKeyCount;
    private String encoding;
    private static Log logger = LogFactory.getLog(CompressFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            if (ae != null && ae.indexOf("gzip") != -1) {
                int i = 0;
                while (i < this.ignoreKeyCount) {
                    if (request.getRequestURI().indexOf(this.ignoreKeys[i]) != -1) {
                        chain.doFilter(req, res);
                        return;
                    }
                    ++i;
                }
                GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response, this.encoding);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                return;
            }
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
        String ignoreKey = filterConfig.getInitParameter("ignoreKey");
        this.ignoreKeys = ignoreKey != null ? StringUtils.split(ignoreKey, ",") : new String[0];
        this.ignoreKeyCount = this.ignoreKeys.length;
        this.encoding = filterConfig.getInitParameter("encoding");
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = System.getProperty("file.encoding");
            logger.warn((Object)("Can't find parameter encoding,use default " + this.encoding));
        }
    }

    public void destroy() {
    }
}

