/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseHyperlink
implements JRHyperlink,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected JRHyperlinkParameter[] hyperlinkParameters;

    public JRBaseHyperlink() {
    }

    protected JRBaseHyperlink(JRHyperlink link, JRBaseObjectFactory factory) {
        factory.put(link, this);
        this.linkType = link.getLinkType();
        this.hyperlinkTarget = link.getHyperlinkTarget();
        this.hyperlinkReferenceExpression = factory.getExpression(link.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(link.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(link.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(link.getHyperlinkTooltipExpression());
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(link, factory);
    }

    public static JRHyperlinkParameter[] copyHyperlinkParameters(JRHyperlink link, JRBaseObjectFactory factory) {
        JRHyperlinkParameter[] linkParameters = link.getHyperlinkParameters();
        JRHyperlinkParameter[] parameters = null;
        if (linkParameters != null && linkParameters.length > 0) {
            parameters = new JRHyperlinkParameter[linkParameters.length];
            for (int i = 0; i < linkParameters.length; ++i) {
                JRHyperlinkParameter parameter = linkParameters[i];
                parameters[i] = factory.getHyperlinkParameter(parameter);
            }
        }
        return parameters;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }
}

