/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Serializer;
import nu.xom.Text;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLSerializer {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$json$xml$XMLSerializer == null ? (class$net$sf$json$xml$XMLSerializer = XMLSerializer.class$("net.sf.json.xml.XMLSerializer")) : class$net$sf$json$xml$XMLSerializer));
    private String arrayName;
    private String elementName;
    private String[] expandableProperties;
    private boolean namespaceLenient;
    private Map nameSpacesPerElement = new TreeMap();
    private String objectName;
    private String rootName;
    private Map rootNameSpace = new TreeMap();
    private boolean typeHintsEnabled;
    static /* synthetic */ Class class$net$sf$json$xml$XMLSerializer;

    public static JSON read(String xml) {
        JSON json = null;
        try {
            Document doc = new Builder().build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            if (XMLSerializer.isNullObject(root)) {
                return JSONNull.getInstance();
            }
            String defaultType = XMLSerializer.getType(root, "string");
            json = XMLSerializer.isArray(root) ? XMLSerializer.processArrayElement(root, defaultType) : XMLSerializer.processObjectElement(root, defaultType);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return json;
    }

    private static boolean checkChildElementsOfArray(Element element) {
        int childCount = element.getChildCount();
        Elements elements = element.getChildElements();
        int elementCount = elements.size();
        if (childCount == 1 && element.getChild(0) instanceof Text) {
            return true;
        }
        if (childCount == elementCount) {
            if (elementCount == 0) {
                return true;
            }
            if (elementCount == 1) {
                return element.getChild(0) instanceof Text;
            }
        }
        if (childCount > elementCount) {
            for (int i = 0; i < childCount; ++i) {
                Text text;
                Node node = element.getChild(i);
                if (!(node instanceof Text) || !StringUtils.isNotBlank((String)StringUtils.strip((String)(text = (Text)node).getValue()))) continue;
                return false;
            }
        }
        String childName = elements.get(0).getQualifiedName();
        for (int i = 1; i < elementCount; ++i) {
            if (childName.compareTo(elements.get(i).getQualifiedName()) == 0) continue;
            return false;
        }
        return true;
    }

    private static String getClass(Element element) {
        Attribute attribute = element.getAttribute("class");
        String clazz = null;
        if (attribute != null) {
            String clazzText = attribute.getValue().trim();
            if ("object".compareToIgnoreCase(clazzText) == 0) {
                clazz = "object";
            } else if ("array".compareToIgnoreCase(clazzText) == 0) {
                clazz = "array";
            }
        }
        return clazz;
    }

    private static String getType(Element element) {
        return XMLSerializer.getType(element, null);
    }

    private static String getType(Element element, String defaultType) {
        Attribute attribute = element.getAttribute("type");
        String type = null;
        if (attribute != null) {
            String typeText = attribute.getValue().trim();
            if ("boolean".compareToIgnoreCase(typeText) == 0) {
                type = "boolean";
            } else if ("number".compareToIgnoreCase(typeText) == 0) {
                type = "number";
            } else if ("integer".compareToIgnoreCase(typeText) == 0) {
                type = "integer";
            } else if ("float".compareToIgnoreCase(typeText) == 0) {
                type = "float";
            } else if ("object".compareToIgnoreCase(typeText) == 0) {
                type = "object";
            } else if ("array".compareToIgnoreCase(typeText) == 0) {
                type = "array";
            } else if ("string".compareToIgnoreCase(typeText) == 0) {
                type = "string";
            } else if ("function".compareToIgnoreCase(typeText) == 0) {
                type = "function";
            }
        } else if (defaultType != null) {
            log.info((Object)("Using default type " + defaultType));
            type = defaultType;
        }
        return type;
    }

    private static boolean isArray(Element element) {
        boolean isArray = false;
        String clazz = XMLSerializer.getClass(element);
        if (clazz != null && clazz.equals("array")) {
            isArray = true;
        } else if (element.getAttributeCount() == 0) {
            isArray = XMLSerializer.checkChildElementsOfArray(element);
        } else if (element.getAttributeCount() == 1 && (element.getAttribute("class") != null || element.getAttribute("type") != null)) {
            isArray = XMLSerializer.checkChildElementsOfArray(element);
        } else if (element.getAttributeCount() == 2 && element.getAttribute("class") != null && element.getAttribute("type") != null) {
            isArray = XMLSerializer.checkChildElementsOfArray(element);
        }
        if (isArray) {
            for (int j = 0; j < element.getNamespaceDeclarationCount(); ++j) {
                String prefix = element.getNamespacePrefix(j);
                String uri = element.getNamespaceURI(prefix);
                if (StringUtils.isBlank((String)uri)) continue;
                return false;
            }
        }
        return isArray;
    }

    private static boolean isNullObject(Element element) {
        if (element.getChildCount() == 0) {
            if (element.getAttributeCount() == 0) {
                return true;
            }
            if (element.getAttribute("null") != null) {
                return true;
            }
            if (element.getAttributeCount() == 1 && (element.getAttribute("class") != null || element.getAttribute("type") != null)) {
                return true;
            }
            if (element.getAttributeCount() == 2 && element.getAttribute("class") != null && element.getAttribute("type") != null) {
                return true;
            }
        }
        return false;
    }

    private static JSON processArrayElement(Element element, String defaultType) {
        JSONArray jsonArray = new JSONArray();
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                if (!StringUtils.isNotBlank((String)StringUtils.strip((String)text.getValue()))) continue;
                jsonArray.put(text.getValue());
                continue;
            }
            if (!(child instanceof Element)) continue;
            XMLSerializer.set(jsonArray, (Element)child, defaultType);
        }
        return jsonArray;
    }

    private static JSON processObjectElement(Element element, String defaultType) {
        if (XMLSerializer.isNullObject(element)) {
            return JSONNull.getInstance();
        }
        JSONObject jsonObject = new JSONObject();
        for (int j = 0; j < element.getNamespaceDeclarationCount(); ++j) {
            String prefix = element.getNamespacePrefix(j);
            String uri = element.getNamespaceURI(prefix);
            if (StringUtils.isBlank((String)uri)) continue;
            if (!StringUtils.isBlank((String)prefix)) {
                prefix = ":" + prefix;
            }
            jsonObject.put("@xmlns" + prefix, uri);
        }
        int attrCount = element.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            Attribute attr = element.getAttribute(i);
            String attrname = attr.getQualifiedName();
            if ("class".compareToIgnoreCase(attrname) == 0 || "type".compareToIgnoreCase(attrname) == 0) continue;
            String attrvalue = attr.getValue();
            jsonObject.put("@" + attrname, attrvalue);
        }
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                if (!StringUtils.isNotBlank((String)StringUtils.strip((String)text.getValue()))) continue;
                jsonObject.put("#text", text.getValue());
                continue;
            }
            if (!(child instanceof Element)) continue;
            XMLSerializer.set(jsonObject, (Element)child, defaultType);
        }
        return jsonObject;
    }

    private static void set(JSONArray jsonArray, Element element, String defaultType) {
        String clazz = XMLSerializer.getClass(element);
        String type = XMLSerializer.getType(element);
        type = type == null ? defaultType : type;
        boolean classProcessed = false;
        if (clazz != null) {
            if (clazz.compareToIgnoreCase("array") == 0) {
                jsonArray.put(XMLSerializer.processArrayElement(element, type));
                classProcessed = true;
            } else if (clazz.compareToIgnoreCase("object") == 0) {
                jsonArray.put(XMLSerializer.processObjectElement(element, type));
                classProcessed = true;
            }
        }
        if (!classProcessed) {
            if (type.compareToIgnoreCase("boolean") == 0) {
                jsonArray.put(Boolean.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("number") == 0) {
                try {
                    jsonArray.put(Integer.valueOf(element.getValue()));
                }
                catch (NumberFormatException e) {
                    jsonArray.put(Double.valueOf(element.getValue()));
                }
            } else if (type.compareToIgnoreCase("integer") == 0) {
                jsonArray.put(Integer.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("float") == 0) {
                jsonArray.put(Double.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("function") == 0) {
                String[] params = null;
                String text = element.getValue();
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    params = StringUtils.split((String)paramsAttribute.getValue(), (String)",");
                }
                jsonArray.put(new JSONFunction(params, text));
            } else if (type.compareToIgnoreCase("string") == 0) {
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    String[] params = null;
                    String text = element.getValue();
                    params = StringUtils.split((String)paramsAttribute.getValue(), (String)",");
                    jsonArray.put(new JSONFunction(params, text));
                } else {
                    jsonArray.put(element.getValue());
                }
            }
        }
    }

    private static void set(JSONObject jsonObject, Element element, String defaultType) {
        String clazz = XMLSerializer.getClass(element);
        String type = XMLSerializer.getType(element);
        type = type == null ? defaultType : type;
        boolean classProcessed = false;
        if (clazz != null) {
            if (clazz.compareToIgnoreCase("array") == 0) {
                jsonObject.put(element.getQualifiedName(), XMLSerializer.processArrayElement(element, type));
                classProcessed = true;
            } else if (clazz.compareToIgnoreCase("object") == 0) {
                jsonObject.put(element.getQualifiedName(), XMLSerializer.processObjectElement(element, type));
                classProcessed = true;
            }
        }
        if (!classProcessed) {
            if (type.compareToIgnoreCase("boolean") == 0) {
                jsonObject.put(element.getQualifiedName(), Boolean.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("number") == 0) {
                try {
                    jsonObject.put(element.getQualifiedName(), Integer.valueOf(element.getValue()));
                }
                catch (NumberFormatException e) {
                    jsonObject.put(element.getQualifiedName(), Double.valueOf(element.getValue()));
                }
            } else if (type.compareToIgnoreCase("integer") == 0) {
                jsonObject.put(element.getQualifiedName(), Integer.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("float") == 0) {
                jsonObject.put(element.getQualifiedName(), Double.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("function") == 0) {
                String[] params = null;
                String text = element.getValue();
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    params = StringUtils.split((String)paramsAttribute.getValue(), (String)",");
                }
                jsonObject.put(element.getQualifiedName(), new JSONFunction(params, text));
            } else if (type.compareToIgnoreCase("string") == 0) {
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    String[] params = null;
                    String text = element.getValue();
                    params = StringUtils.split((String)paramsAttribute.getValue(), (String)",");
                    jsonObject.put(element.getQualifiedName(), new JSONFunction(params, text));
                } else {
                    jsonObject.put(element.getQualifiedName(), element.getValue());
                }
            }
        }
    }

    public XMLSerializer() {
        this.setObjectName("o");
        this.setArrayName("a");
        this.setElementName("e");
        this.setTypeHintsEnabled(true);
        this.setNamespaceLenient(false);
        this.setExpandableProperties(EMPTY_ARRAY);
    }

    public void addNamespace(String prefix, String uri) {
        this.addNamespace(prefix, uri, null);
    }

    public void addNamespace(String prefix, String uri, String elementName) {
        if (StringUtils.isBlank((String)uri)) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (StringUtils.isBlank((String)elementName)) {
            this.rootNameSpace.put(prefix.trim(), uri.trim());
        } else {
            TreeMap<String, String> nameSpaces = (TreeMap<String, String>)this.nameSpacesPerElement.get(elementName);
            if (nameSpaces == null) {
                nameSpaces = new TreeMap<String, String>();
                this.nameSpacesPerElement.put(elementName, nameSpaces);
            }
            nameSpaces.put(prefix, uri);
        }
    }

    public void clearNamespaces() {
        this.rootNameSpace.clear();
        this.nameSpacesPerElement.clear();
    }

    public void clearNamespaces(String elementName) {
        if (StringUtils.isBlank((String)elementName)) {
            this.rootNameSpace.clear();
        } else {
            this.nameSpacesPerElement.remove(elementName);
        }
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String[] getExpandableProperties() {
        return this.expandableProperties;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getRootName() {
        return this.rootName;
    }

    public boolean isNamespaceLenient() {
        return this.namespaceLenient;
    }

    public boolean isTypeHintsEnabled() {
        return this.typeHintsEnabled;
    }

    public void removeNamespace(String prefix) {
        this.removeNamespace(prefix, null);
    }

    public void removeNamespace(String prefix, String elementName) {
        if (prefix == null) {
            prefix = "";
        }
        if (StringUtils.isBlank((String)elementName)) {
            this.rootNameSpace.remove(prefix.trim());
        } else {
            Map nameSpaces = (Map)this.nameSpacesPerElement.get(elementName);
            nameSpaces.remove(prefix);
        }
    }

    public void setArrayName(String arrayName) {
        this.arrayName = StringUtils.isBlank((String)arrayName) ? "a" : arrayName;
    }

    public void setElementName(String elementName) {
        this.elementName = StringUtils.isBlank((String)elementName) ? "e" : elementName;
    }

    public void setExpandableProperties(String[] expandableProperties) {
        this.expandableProperties = expandableProperties == null ? EMPTY_ARRAY : expandableProperties;
    }

    public void setNamespace(String prefix, String uri) {
        this.setNamespace(prefix, uri, null);
    }

    public void setNamespace(String prefix, String uri, String elementName) {
        if (StringUtils.isBlank((String)uri)) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (StringUtils.isBlank((String)elementName)) {
            this.rootNameSpace.clear();
            this.rootNameSpace.put(prefix.trim(), uri.trim());
        } else {
            TreeMap<String, String> nameSpaces = (TreeMap<String, String>)this.nameSpacesPerElement.get(elementName);
            if (nameSpaces == null) {
                nameSpaces = new TreeMap<String, String>();
                this.nameSpacesPerElement.put(elementName, nameSpaces);
            }
            nameSpaces.clear();
            nameSpaces.put(prefix, uri);
        }
    }

    public void setNamespaceLenient(boolean namespaceLenient) {
        this.namespaceLenient = namespaceLenient;
    }

    public void setObjectName(String objectName) {
        this.objectName = StringUtils.isBlank((String)objectName) ? "o" : objectName;
    }

    public void setRootName(String rootName) {
        this.rootName = StringUtils.isBlank((String)rootName) ? null : rootName;
    }

    public void setTypeHintsEnabled(boolean typeHintsEnabled) {
        this.typeHintsEnabled = typeHintsEnabled;
    }

    public String write(JSON json) {
        return this.write(json, null);
    }

    public String write(JSON json, String encoding) {
        if (JSONNull.getInstance().equals(json)) {
            Element root = null;
            root = this.newElement(this.getRootName() == null ? this.getObjectName() : this.getRootName());
            root.addAttribute(new Attribute("null", "true"));
            Document doc = new Document(root);
            return this.writeDocument(doc, encoding);
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            Element root = this.processJSONArray(jsonArray, this.newElement(this.getRootName() == null ? this.getArrayName() : this.getRootName()), this.expandableProperties);
            Document doc = new Document(root);
            return this.writeDocument(doc, encoding);
        }
        JSONObject jsonObject = (JSONObject)json;
        Element root = null;
        if (jsonObject.isNullObject()) {
            root = this.newElement(this.getObjectName());
            root.addAttribute(new Attribute("null", "true"));
        } else {
            root = this.processJSONObject(jsonObject, this.newElement(this.getRootName() == null ? this.getObjectName() : this.getRootName()), this.expandableProperties, true);
        }
        Document doc = new Document(root);
        return this.writeDocument(doc, encoding);
    }

    private void addNameSpaceToElement(Element element) {
        String elementName = null;
        elementName = element instanceof CustomElement ? ((CustomElement)element).getQName() : element.getQualifiedName();
        Map nameSpaces = (Map)this.nameSpacesPerElement.get(elementName);
        if (nameSpaces != null && !nameSpaces.isEmpty()) {
            this.setNamespaceLenient(true);
            Iterator entries = nameSpaces.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                if (StringUtils.isBlank((String)prefix)) {
                    element.setNamespaceURI(uri);
                    continue;
                }
                element.addNamespaceDeclaration(prefix, uri);
            }
        }
    }

    private Element newElement(String name) {
        if (name.indexOf(58) != -1) {
            this.namespaceLenient = true;
        }
        return this.namespaceLenient ? new CustomElement(name) : new Element(name);
    }

    private Element processJSONArray(JSONArray array, Element root, String[] expandableProperties) {
        int l = array.length();
        for (int i = 0; i < l; ++i) {
            Object value = array.get(i);
            Element element = this.processJSONValue(value, root, null, expandableProperties);
            root.appendChild((Node)element);
        }
        return root;
    }

    private Element processJSONObject(JSONObject jsonObject, Element root, String[] expandableProperties, boolean isRoot) {
        if (jsonObject.isNullObject()) {
            root.addAttribute(new Attribute("null", "true"));
            return root;
        }
        if (jsonObject.isEmpty()) {
            return root;
        }
        if (isRoot && !this.rootNameSpace.isEmpty()) {
            this.setNamespaceLenient(true);
            Iterator entries = this.rootNameSpace.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                if (StringUtils.isBlank((String)prefix)) {
                    root.setNamespaceURI(uri);
                    continue;
                }
                root.addNamespaceDeclaration(prefix, uri);
            }
        }
        this.addNameSpaceToElement(root);
        Object[] names = jsonObject.names().toArray();
        Arrays.sort(names);
        Element element = null;
        for (int i = 0; i < names.length; ++i) {
            String name = (String)names[i];
            Object value = jsonObject.get(name);
            if (name.startsWith("@xmlns")) {
                this.setNamespaceLenient(true);
                int colon = name.indexOf(58);
                if (colon == -1) {
                    if (!StringUtils.isBlank((String)root.getNamespaceURI())) continue;
                    root.setNamespaceURI(String.valueOf(value));
                    continue;
                }
                String prefix = name.substring(colon + 1);
                if (!StringUtils.isBlank((String)root.getNamespaceURI(prefix))) continue;
                root.addNamespaceDeclaration(prefix, String.valueOf(value));
                continue;
            }
            if (name.startsWith("@")) {
                root.addAttribute(new Attribute(name.substring(1), String.valueOf(value)));
                continue;
            }
            if (name.equals("#text")) {
                if (value instanceof JSONArray) {
                    root.appendChild(((JSONArray)value).join("", true));
                    continue;
                }
                root.appendChild(String.valueOf(value));
                continue;
            }
            if (value instanceof JSONArray && (((JSONArray)value).isExpandElements() || ArrayUtils.contains((Object[])expandableProperties, (Object)name))) {
                JSONArray array = (JSONArray)value;
                int l = array.length();
                for (int j = 0; j < l; ++j) {
                    Object item = array.get(j);
                    element = this.newElement(name);
                    element = item instanceof JSONObject ? this.processJSONValue((JSONObject)item, root, element, expandableProperties) : (item instanceof JSONArray ? this.processJSONValue((JSONArray)item, root, element, expandableProperties) : this.processJSONValue(item, root, element, expandableProperties));
                    this.addNameSpaceToElement(element);
                    root.appendChild((Node)element);
                }
                continue;
            }
            element = this.newElement(name);
            element = this.processJSONValue(value, root, element, expandableProperties);
            this.addNameSpaceToElement(element);
            root.appendChild((Node)element);
        }
        return root;
    }

    private Element processJSONValue(Object value, Element root, Element target, String[] expandableProperties) {
        if (target == null) {
            target = this.newElement(this.getElementName());
        }
        if (JSONUtils.isBoolean(value)) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("type", "boolean"));
            }
            target.appendChild(value.toString());
        } else if (JSONUtils.isNumber(value)) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("type", "number"));
            }
            target.appendChild(value.toString());
        } else if (JSONUtils.isFunction(value)) {
            JSONFunction func = (JSONFunction)value;
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("type", "function"));
            }
            String params = ArrayUtils.toString((Object)func.getParams());
            params = params.substring(1);
            params = params.substring(0, params.length() - 1);
            target.addAttribute(new Attribute("params", params));
            target.appendChild((Node)new Text("<![CDATA[" + func.getText() + "]]>"));
        } else if (JSONUtils.isString(value)) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("type", "string"));
            }
            target.appendChild(value.toString());
        } else if (value instanceof JSONArray) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("class", "array"));
            }
            target = this.processJSONArray((JSONArray)value, target, expandableProperties);
        } else if (value instanceof JSONObject) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("class", "object"));
            }
            target = this.processJSONObject((JSONObject)value, target, expandableProperties, false);
        } else if (JSONUtils.isNull(value)) {
            if (this.isTypeHintsEnabled()) {
                target.addAttribute(new Attribute("class", "object"));
            }
            target.addAttribute(new Attribute("null", "true"));
        }
        return target;
    }

    private String writeDocument(Document doc, String encoding) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XomSerializer serializer = encoding == null ? new XomSerializer(baos) : new XomSerializer(baos, encoding);
            serializer.write(doc);
        }
        catch (IOException ioe) {
            throw new JSONException(ioe);
        }
        return baos.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XomSerializer
    extends Serializer {
        public XomSerializer(OutputStream out) {
            super(out);
        }

        public XomSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        protected void write(Text text) throws IOException {
            String value = text.getValue();
            if (value.startsWith("<![CDATA[") && value.endsWith("]]>")) {
                value = value.substring(9);
                value = value.substring(0, value.length() - 3);
                this.writeRaw("<![CDATA[");
                this.writeRaw(value);
                this.writeRaw("]]>");
            } else {
                super.write(text);
            }
        }

        protected void writeEmptyElementTag(Element element) throws IOException {
            if (element instanceof CustomElement && XMLSerializer.this.isNamespaceLenient()) {
                this.writeTagBeginning((CustomElement)element);
                this.writeRaw("/>");
            } else {
                super.writeEmptyElementTag(element);
            }
        }

        protected void writeEndTag(Element element) throws IOException {
            if (element instanceof CustomElement && XMLSerializer.this.isNamespaceLenient()) {
                this.writeRaw("</");
                this.writeRaw(((CustomElement)element).getQName());
                this.writeRaw(">");
            } else {
                super.writeEndTag(element);
            }
        }

        protected void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
            if (!StringUtils.isBlank((String)uri)) {
                super.writeNamespaceDeclaration(prefix, uri);
            }
        }

        protected void writeStartTag(Element element) throws IOException {
            if (element instanceof CustomElement && XMLSerializer.this.isNamespaceLenient()) {
                this.writeTagBeginning((CustomElement)element);
                this.writeRaw(">");
            } else {
                super.writeStartTag(element);
            }
        }

        private void writeTagBeginning(CustomElement element) throws IOException {
            this.writeRaw("<");
            this.writeRaw(element.getQName());
            this.writeAttributes(element);
            this.writeNamespaceDeclarations(element);
        }
    }

    private static class CustomElement
    extends Element {
        private String prefix;

        private static String getName(String name) {
            int colon = name.indexOf(58);
            if (colon != -1) {
                return name.substring(colon + 1);
            }
            return name;
        }

        private static String getPrefix(String name) {
            int colon = name.indexOf(58);
            if (colon != -1) {
                return name.substring(0, colon);
            }
            return "";
        }

        public CustomElement(String name) {
            super(CustomElement.getName(name));
            this.prefix = CustomElement.getPrefix(name);
        }

        public final String getQName() {
            if (this.prefix.length() == 0) {
                return this.getLocalName();
            }
            return this.prefix + ":" + this.getLocalName();
        }
    }
}

