/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.io.BufferPool;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3Q!\u0001\u0002\u0001\t\u0019\u0011A\u0003R5sK\u000e$()\u001f;f\u0005V4g-\u001a:Q_>d'BA\u0002\u0005\u0003\tIwNC\u0001\u0006\u0003\u0011\t7n[1\u0014\u0007\u00019Q\u0002\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011!BQ;gM\u0016\u0014\bk\\8m\u0011!\u0011\u0002A!A!\u0002\u0013!\u0012!\u00053fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K\u000e\u0001\u0001C\u0001\u0005\u0016\u0013\t1\u0012BA\u0002J]RD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u000f[\u0006D\bk\\8m\u000b:$(/[3t\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0019A$\b\u0010\u0011\u00059\u0001\u0001\"\u0002\n\u001a\u0001\u0004!\u0002\"\u0002\r\u001a\u0001\u0004!\u0002B\u0002\u0011\u0001A\u0003%\u0011%\u0001\u0004m_\u000e\\W\r\u001a\t\u0003E-j\u0011a\t\u0006\u0003I\u0015\na!\u0019;p[&\u001c'B\u0001\u0014(\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Q%\nA!\u001e;jY*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017$\u00055\tEo\\7jG\n{w\u000e\\3b]\"1a\u0006\u0001Q\u0001\n=\nA\u0001]8pYB\u0019\u0001\u0002\r\u001a\n\u0005EJ!!B!se\u0006L\bCA\u001a7\u001b\u0005!$BA\u001b*\u0003\rq\u0017n\\\u0005\u0003oQ\u0012!BQ=uK\n+hMZ3s\u0011\u0019I\u0004\u0001)Q\u0005)\u0005i!-\u001e4gKJ\u001c\u0018J\u001c)p_2DQa\u000f\u0001\u0005\u0002q\nq!Y2rk&\u0014X\rF\u00013\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u001d\u0011X\r\\3bg\u0016$\"\u0001Q\"\u0011\u0005!\t\u0015B\u0001\"\n\u0005\u0011)f.\u001b;\t\u000b\u0011k\u0004\u0019\u0001\u001a\u0002\u0007\t,h\rC\u0003G\u0001\u0011%q)\u0001\u0005bY2|7-\u0019;f)\t\u0011\u0004\nC\u0003J\u000b\u0002\u0007A#\u0001\u0003tSj,\u0007\"B&\u0001\t\u001ba\u0014A\u0005;bW\u0016\u0014UO\u001a4fe\u001a\u0013x.\u001c)p_2D#AS'\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0011AC1o]>$\u0018\r^5p]&\u0011!k\u0014\u0002\bi\u0006LGN]3d\u0011\u0015!\u0006\u0001\"\u0004V\u0003EygMZ3s\u0005V4g-\u001a:U_B{w\u000e\u001c\u000b\u0003\u0001ZCQ\u0001R*A\u0002IB#aU'")
public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final AtomicBoolean locked;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size2) {
        return ByteBuffer.allocateDirect(size2);
    }

    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer byteBuffer;
        block7: {
            ByteBuffer byteBuffer2;
            while (!this.locked.compareAndSet(false, true)) {
            }
            if (this.buffersInPool > 0) {
                --this.buffersInPool;
                byteBuffer2 = this.pool[this.buffersInPool];
            } else {
                byteBuffer2 = null;
            }
            ByteBuffer buffer = byteBuffer2;
            if (buffer == null) {
                byteBuffer = this.allocate(this.defaultBufferSize);
                break block7;
            }
            buffer.clear();
            byteBuffer = buffer;
        }
        return byteBuffer;
        finally {
            this.locked.set(false);
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        while (true) {
            BoxedUnit boxedUnit;
            if (!this.locked.compareAndSet(false, true)) continue;
            if (this.buffersInPool < this.maxPoolEntries) {
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        finally {
            this.locked.set(false);
        }
    }

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.locked = new AtomicBoolean(false);
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }
}

