/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.io.NumberInput;

public class JsonPointer {
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected final String _asString;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = "";
        this._matchingElementIndex = -1;
        this._asString = "";
    }

    protected JsonPointer(String fullString, String segment, JsonPointer next2) {
        this._asString = fullString;
        this._nextSegment = next2;
        this._matchingPropertyName = segment;
        this._matchingElementIndex = JsonPointer._parseIndex(segment);
    }

    public static JsonPointer compile(String input2) throws IllegalArgumentException {
        if (input2 == null || input2.length() == 0) {
            return EMPTY;
        }
        if (input2.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + input2 + "\"");
        }
        return JsonPointer._parseTail(input2);
    }

    public static JsonPointer valueOf(String input2) {
        return JsonPointer.compile(input2);
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer matchProperty(String name) {
        if (this._nextSegment == null || !this._matchingPropertyName.equals(name)) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer matchElement(int index) {
        if (index != this._matchingElementIndex || index < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public String toString() {
        return this._asString;
    }

    public int hashCode() {
        return this._asString.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof JsonPointer)) {
            return false;
        }
        return this._asString.equals(((JsonPointer)o)._asString);
    }

    private static final int _parseIndex(String str) {
        long l;
        int len2 = str.length();
        if (len2 == 0 || len2 > 10) {
            return -1;
        }
        for (int i = 0; i < len2; ++i) {
            char c;
            if ((c = str.charAt(i++)) <= '9' && c >= '0') continue;
            return -1;
        }
        if (len2 == 10 && (l = NumberInput.parseLong(str)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(str);
    }

    protected static JsonPointer _parseTail(String input2) {
        int end = input2.length();
        int i = 1;
        while (i < end) {
            char c = input2.charAt(i);
            if (c == '/') {
                return new JsonPointer(input2, input2.substring(1, i), JsonPointer._parseTail(input2.substring(i)));
            }
            if (c != '~' || ++i >= end) continue;
            return JsonPointer._parseQuotedTail(input2, i);
        }
        return new JsonPointer(input2, input2.substring(1), EMPTY);
    }

    protected static JsonPointer _parseQuotedTail(String input2, int i) {
        int end = input2.length();
        StringBuilder sb = new StringBuilder(Math.max(16, end));
        if (i > 2) {
            sb.append(input2, 1, i - 1);
        }
        JsonPointer._appendEscape(sb, input2.charAt(i++));
        while (i < end) {
            char c = input2.charAt(i);
            if (c == '/') {
                return new JsonPointer(input2, sb.toString(), JsonPointer._parseTail(input2.substring(i)));
            }
            if (c == '~' && ++i < end) {
                JsonPointer._appendEscape(sb, input2.charAt(i++));
                continue;
            }
            sb.append(c);
        }
        return new JsonPointer(input2, sb.toString(), EMPTY);
    }

    private static void _appendEscape(StringBuilder sb, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            sb.append('~');
        }
        sb.append(c);
    }
}

