/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONBinarySubType;
import com.mongodb.BSONBinaryWriterSettings;
import com.mongodb.BSONContextType;
import com.mongodb.BSONType;
import com.mongodb.BSONWriter;
import com.mongodb.BSONWriterSettings;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.MongoInternalException;
import java.util.Stack;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.bson.util.Assertions;

class BSONBinaryWriter
extends BSONWriter {
    private final BSONBinaryWriterSettings binaryWriterSettings;
    private final OutputBuffer buffer;
    private final Stack<Integer> maxDocumentSizeStack = new Stack();
    private Mark mark;

    public BSONBinaryWriter(OutputBuffer buffer) {
        this(new BSONWriterSettings(), new BSONBinaryWriterSettings(), buffer);
    }

    public BSONBinaryWriter(BSONWriterSettings settings, BSONBinaryWriterSettings binaryWriterSettings, OutputBuffer buffer) {
        super(settings);
        this.binaryWriterSettings = binaryWriterSettings;
        this.buffer = buffer;
        this.maxDocumentSizeStack.push(binaryWriterSettings.getMaxDocumentSize());
    }

    public void close() {
        super.close();
    }

    public OutputBuffer getBuffer() {
        return this.buffer;
    }

    public void flush() {
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    public void writeBinaryData(Binary binary) {
        this.checkPreconditions("writeBinaryData", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.BINARY.getValue());
        this.writeCurrentName();
        int totalLen = binary.length();
        if (binary.getType() == BSONBinarySubType.OldBinary.getValue()) {
            totalLen += 4;
        }
        this.buffer.writeInt(totalLen);
        this.buffer.write(binary.getType());
        if (binary.getType() == BSONBinarySubType.OldBinary.getValue()) {
            this.buffer.writeInt(totalLen - 4);
        }
        this.buffer.write(binary.getData());
        this.setState(this.getNextState());
    }

    public void writeBoolean(boolean value) {
        this.checkPreconditions("writeBoolean", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.BOOLEAN.getValue());
        this.writeCurrentName();
        this.buffer.write(value ? 1 : 0);
        this.setState(this.getNextState());
    }

    public void writeDateTime(long value) {
        this.checkPreconditions("writeDateTime", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.DATE_TIME.getValue());
        this.writeCurrentName();
        this.buffer.writeLong(value);
        this.setState(this.getNextState());
    }

    public void writeDouble(double value) {
        this.checkPreconditions("writeDouble", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.DOUBLE.getValue());
        this.writeCurrentName();
        this.buffer.writeDouble(value);
        this.setState(this.getNextState());
    }

    public void writeInt32(int value) {
        this.checkPreconditions("writeInt32", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.INT32.getValue());
        this.writeCurrentName();
        this.buffer.writeInt(value);
        this.setState(this.getNextState());
    }

    public void writeInt64(long value) {
        this.checkPreconditions("writeInt64", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.INT64.getValue());
        this.writeCurrentName();
        this.buffer.writeLong(value);
        this.setState(this.getNextState());
    }

    public void writeJavaScript(String code) {
        this.checkPreconditions("writeJavaScript", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.JAVASCRIPT.getValue());
        this.writeCurrentName();
        this.buffer.writeString(code);
        this.setState(this.getNextState());
    }

    public void writeJavaScriptWithScope(String code) {
        this.checkPreconditions("writeJavaScriptWithScope", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.JAVASCRIPT_WITH_SCOPE.getValue());
        this.writeCurrentName();
        this.setContext(new Context(this.getContext(), BSONContextType.JAVASCRIPT_WITH_SCOPE, this.buffer.getPosition()));
        this.buffer.writeInt(0);
        this.buffer.writeString(code);
        this.setState(BSONWriter.State.SCOPE_DOCUMENT);
    }

    public void writeMaxKey() {
        this.checkPreconditions("writeMaxKey", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.MAX_KEY.getValue());
        this.writeCurrentName();
        this.setState(this.getNextState());
    }

    public void writeMinKey() {
        this.checkPreconditions("writeMinKey", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.MIN_KEY.getValue());
        this.writeCurrentName();
        this.setState(this.getNextState());
    }

    public void writeNull() {
        this.checkPreconditions("writeNull", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.NULL.getValue());
        this.writeCurrentName();
        this.setState(this.getNextState());
    }

    public void writeObjectId(ObjectId objectId) {
        this.checkPreconditions("writeObjectId", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.OBJECT_ID.getValue());
        this.writeCurrentName();
        this.buffer.write(objectId.toByteArray());
        this.setState(this.getNextState());
    }

    public void writeString(String value) {
        this.checkPreconditions("writeString", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.STRING.getValue());
        this.writeCurrentName();
        this.buffer.writeString(value);
        this.setState(this.getNextState());
    }

    public void writeSymbol(String value) {
        this.checkPreconditions("writeSymbol", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.SYMBOL.getValue());
        this.writeCurrentName();
        this.buffer.writeString(value);
        this.setState(this.getNextState());
    }

    public void writeTimestamp(BSONTimestamp value) {
        this.checkPreconditions("writeTimestamp", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.TIMESTAMP.getValue());
        this.writeCurrentName();
        this.buffer.writeInt(value.getInc());
        this.buffer.writeInt(value.getTime());
        this.setState(this.getNextState());
    }

    public void writeUndefined() {
        this.checkPreconditions("writeUndefined", BSONWriter.State.VALUE);
        this.buffer.write(BSONType.UNDEFINED.getValue());
        this.writeCurrentName();
        this.setState(this.getNextState());
    }

    public void writeStartArray() {
        this.checkPreconditions("writeStartArray", BSONWriter.State.VALUE);
        super.writeStartArray();
        this.buffer.write(BSONType.ARRAY.getValue());
        this.writeCurrentName();
        this.setContext(new Context(this.getContext(), BSONContextType.ARRAY, this.buffer.getPosition()));
        this.buffer.writeInt(0);
        this.setState(BSONWriter.State.VALUE);
    }

    public void writeStartDocument() {
        this.checkPreconditions("writeStartDocument", BSONWriter.State.INITIAL, BSONWriter.State.VALUE, BSONWriter.State.SCOPE_DOCUMENT, BSONWriter.State.DONE);
        super.writeStartDocument();
        if (this.getState() == BSONWriter.State.VALUE) {
            this.buffer.write(BSONType.DOCUMENT.getValue());
            this.writeCurrentName();
        }
        this.setContext(new Context(this.getContext(), BSONContextType.DOCUMENT, this.buffer.getPosition()));
        this.buffer.writeInt(0);
        this.setState(BSONWriter.State.NAME);
    }

    public void writeEndArray() {
        this.checkPreconditions("writeEndArray", BSONWriter.State.VALUE);
        if (this.getContext().getContextType() != BSONContextType.ARRAY) {
            this.throwInvalidContextType("WriteEndArray", this.getContext().getContextType(), BSONContextType.ARRAY);
        }
        super.writeEndArray();
        this.buffer.write(0);
        this.backpatchSize();
        this.setContext(this.getContext().getParentContext());
        this.setState(this.getNextState());
    }

    public void writeEndDocument() {
        this.checkPreconditions("writeEndDocument", BSONWriter.State.NAME);
        BSONContextType contextType = this.getContext().getContextType();
        if (contextType != BSONContextType.DOCUMENT && contextType != BSONContextType.SCOPE_DOCUMENT) {
            this.throwInvalidContextType("WriteEndDocument", contextType, BSONContextType.DOCUMENT, BSONContextType.SCOPE_DOCUMENT);
        }
        super.writeEndDocument();
        this.buffer.write(0);
        this.backpatchSize();
        this.setContext(this.getContext().getParentContext());
        if (this.getContext() == null) {
            this.setState(BSONWriter.State.DONE);
        } else {
            if (this.getContext().getContextType() == BSONContextType.JAVASCRIPT_WITH_SCOPE) {
                this.backpatchSize();
                this.setContext(this.getContext().getParentContext());
            }
            this.setState(this.getNextState());
        }
    }

    public void encodeDocument(DBEncoder encoder, DBObject dbObject) {
        this.checkPreconditions("writeStartDocument", BSONWriter.State.INITIAL, BSONWriter.State.VALUE, BSONWriter.State.SCOPE_DOCUMENT, BSONWriter.State.DONE);
        Assertions.isTrue("state is VALUE", this.getState() == BSONWriter.State.VALUE);
        Assertions.isTrue("context not null", this.getContext() != null);
        Assertions.isTrue("context is not JAVASCRIPT_WITH_SCOPE", this.getContext().getContextType() != BSONContextType.JAVASCRIPT_WITH_SCOPE);
        this.buffer.write(BSONType.DOCUMENT.getValue());
        this.writeCurrentName();
        int startPos = this.buffer.getPosition();
        encoder.writeObject(this.buffer, dbObject);
        this.throwIfSizeExceedsLimit(this.buffer.getPosition() - startPos);
        this.setState(this.getNextState());
    }

    public void pushMaxDocumentSize(int maxDocumentSize) {
        this.maxDocumentSizeStack.push(maxDocumentSize);
    }

    public void popMaxDocumentSize() {
        this.maxDocumentSizeStack.pop();
    }

    public void mark() {
        this.mark = new Mark();
    }

    public void reset() {
        if (this.mark == null) {
            throw new IllegalStateException("Can not reset without first marking");
        }
        this.mark.reset();
        this.mark = null;
    }

    private void writeCurrentName() {
        if (this.getContext().getContextType() == BSONContextType.ARRAY) {
            this.buffer.writeCString(Integer.toString(this.getContext().index++));
        } else {
            this.buffer.writeCString(this.getName());
        }
    }

    private void backpatchSize() {
        int size2 = this.buffer.getPosition() - this.getContext().startPosition;
        this.throwIfSizeExceedsLimit(size2);
        this.buffer.backpatchSize(size2);
    }

    private void throwIfSizeExceedsLimit(int size2) {
        if (size2 > this.maxDocumentSizeStack.peek()) {
            String message = String.format("Size %d is larger than MaxDocumentSize %d.", this.buffer.getPosition() - this.getContext().startPosition, this.binaryWriterSettings.getMaxDocumentSize());
            throw new MongoInternalException(message);
        }
    }

    class Mark
    extends BSONWriter.Mark {
        private final int position;

        protected Mark() {
            super(BSONBinaryWriter.this);
            this.position = BSONBinaryWriter.this.buffer.getPosition();
        }

        protected void reset() {
            super.reset();
            BSONBinaryWriter.this.buffer.truncateToPosition(((BSONBinaryWriter)BSONBinaryWriter.this).mark.position);
        }
    }

    class Context
    extends BSONWriter.Context {
        private final int startPosition;
        private int index;

        public Context(Context parentContext, BSONContextType contextType, int startPosition) {
            super(BSONBinaryWriter.this, parentContext, contextType);
            this.startPosition = startPosition;
        }

        public Context(Context from2) {
            super(BSONBinaryWriter.this, from2);
            this.startPosition = from2.startPosition;
            this.index = from2.index;
        }

        public Context getParentContext() {
            return (Context)super.getParentContext();
        }

        public Context copy() {
            return new Context(this);
        }
    }
}

