/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONContextType;
import com.mongodb.BSONWriterSettings;
import com.mongodb.StringUtils;
import java.io.Closeable;
import java.util.Arrays;
import org.bson.BSONException;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

abstract class BSONWriter
implements Closeable {
    private final BSONWriterSettings settings;
    private State state;
    private Context context;
    private String currentName;
    private int serializationDepth;
    private boolean closed;

    protected BSONWriter(BSONWriterSettings settings) {
        this.settings = settings;
        this.state = State.INITIAL;
    }

    protected String getName() {
        return this.currentName;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected State getState() {
        return this.state;
    }

    protected Context getContext() {
        return this.context;
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    public abstract void flush();

    public abstract void writeBinaryData(Binary var1);

    public void writeBinaryData(String name, Binary binary) {
        this.writeName(name);
        this.writeBinaryData(binary);
    }

    public abstract void writeBoolean(boolean var1);

    public void writeBoolean(String name, boolean value) {
        this.writeName(name);
        this.writeBoolean(value);
    }

    public abstract void writeDateTime(long var1);

    public void writeDateTime(String name, long value) {
        this.writeName(name);
        this.writeDateTime(value);
    }

    public abstract void writeDouble(double var1);

    public void writeDouble(String name, double value) {
        this.writeName(name);
        this.writeDouble(value);
    }

    public void writeEndArray() {
        --this.serializationDepth;
    }

    public void writeEndDocument() {
        --this.serializationDepth;
    }

    public abstract void writeInt32(int var1);

    public void writeInt32(String name, int value) {
        this.writeName(name);
        this.writeInt32(value);
    }

    public abstract void writeInt64(long var1);

    public void writeInt64(String name, long value) {
        this.writeName(name);
        this.writeInt64(value);
    }

    public abstract void writeJavaScript(String var1);

    public void writeJavaScript(String name, String code) {
        this.writeName(name);
        this.writeJavaScript(code);
    }

    public abstract void writeJavaScriptWithScope(String var1);

    public void writeJavaScriptWithScope(String name, String code) {
        this.writeName(name);
        this.writeJavaScriptWithScope(code);
    }

    public abstract void writeMaxKey();

    public void writeMaxKey(String name) {
        this.writeName(name);
        this.writeMaxKey();
    }

    public abstract void writeMinKey();

    public void writeMinKey(String name) {
        this.writeName(name);
        this.writeMinKey();
    }

    public void writeName(String name) {
        if (this.state != State.NAME) {
            this.throwInvalidState("WriteName", State.NAME);
        }
        this.currentName = name;
        this.state = State.VALUE;
    }

    public abstract void writeNull();

    public void writeNull(String name) {
        this.writeName(name);
        this.writeNull();
    }

    public abstract void writeObjectId(ObjectId var1);

    public void writeObjectId(String name, ObjectId objectId) {
        this.writeName(name);
        this.writeObjectId(objectId);
    }

    public void writeStartArray() {
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BSONException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
    }

    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    public void writeStartDocument() {
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BSONException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
    }

    public void writeStartDocument(String name) {
        this.writeName(name);
        this.writeStartDocument();
    }

    public abstract void writeString(String var1);

    public void writeString(String name, String value) {
        this.writeName(name);
        this.writeString(value);
    }

    public abstract void writeSymbol(String var1);

    public void writeSymbol(String name, String value) {
        this.writeName(name);
        this.writeSymbol(value);
    }

    public abstract void writeTimestamp(BSONTimestamp var1);

    public void writeTimestamp(String name, BSONTimestamp value) {
        this.writeName(name);
        this.writeTimestamp(value);
    }

    public abstract void writeUndefined();

    public void writeUndefined(String name) {
        this.writeName(name);
        this.writeUndefined();
    }

    protected State getNextState() {
        if (this.getContext().getContextType() == BSONContextType.ARRAY) {
            return State.VALUE;
        }
        return State.NAME;
    }

    protected boolean checkState(State[] validStates) {
        for (State cur : validStates) {
            if (cur != this.getState()) continue;
            return true;
        }
        return false;
    }

    protected void checkPreconditions(String methodName, State ... validStates) {
        if (this.isClosed()) {
            throw new IllegalStateException("BSONWriter");
        }
        if (!this.checkState(validStates)) {
            this.throwInvalidState(methodName, validStates);
        }
    }

    protected void throwInvalidContextType(String methodName, BSONContextType actualContextType, BSONContextType ... validContextTypes) {
        String validContextTypesString = StringUtils.join(" or ", Arrays.asList(validContextTypes));
        String message = String.format("%s can only be called when ContextType is %s, not when ContextType is %s.", new Object[]{methodName, validContextTypesString, actualContextType});
        throw new BSONException(message);
    }

    protected void throwInvalidState(String methodName, State ... validStates) {
        if (!(this.state != State.INITIAL && this.state != State.SCOPE_DOCUMENT && this.state != State.DONE || methodName.startsWith("end") || methodName.equals("writeName"))) {
            String typeName = methodName.substring(5);
            if (typeName.startsWith("start")) {
                typeName = typeName.substring(5);
            }
            String article = "A";
            if (Arrays.asList(Character.valueOf('A'), Character.valueOf('E'), Character.valueOf('I'), Character.valueOf('O'), Character.valueOf('U')).contains(Character.valueOf(typeName.charAt(0)))) {
                article = "An";
            }
            String message = String.format("%s %s value cannot be written to the root level of a BSON document.", article, typeName);
            throw new BSONException(message);
        }
        String validStatesString = StringUtils.join(" or ", Arrays.asList(validStates));
        String message = String.format("%s can only be called when State is %s, not when State is %s", new Object[]{methodName, validStatesString, this.state});
        throw new BSONException(message);
    }

    public void close() {
        this.closed = true;
    }

    class Mark {
        private final Context markedContext;
        private final State markedState;
        private final String currentName;
        private final int serializationDepth;

        protected Mark() {
            this.markedContext = BSONWriter.this.context.copy();
            this.markedState = BSONWriter.this.state;
            this.currentName = BSONWriter.this.currentName;
            this.serializationDepth = BSONWriter.this.serializationDepth;
        }

        protected void reset() {
            BSONWriter.this.setContext(this.markedContext);
            BSONWriter.this.setState(this.markedState);
            BSONWriter.this.currentName = this.currentName;
            BSONWriter.this.serializationDepth = this.serializationDepth;
        }
    }

    class Context {
        private final Context parentContext;
        private final BSONContextType contextType;

        public Context(Context from2) {
            this.parentContext = from2.parentContext;
            this.contextType = from2.contextType;
        }

        public Context(Context parentContext, BSONContextType contextType) {
            this.parentContext = parentContext;
            this.contextType = contextType;
        }

        public Context getParentContext() {
            return this.parentContext;
        }

        public BSONContextType getContextType() {
            return this.contextType;
        }

        public Context copy() {
            return new Context(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        NAME,
        VALUE,
        SCOPE_DOCUMENT,
        DONE,
        CLOSED;

    }
}

