/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteOperation;
import com.mongodb.DBObject;
import com.mongodb.ReplaceRequest;
import com.mongodb.UpdateRequest;

public class BulkUpdateRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final boolean upsert;

    BulkUpdateRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, boolean upsert) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.upsert = upsert;
    }

    public void replaceOne(DBObject document) {
        this.bulkWriteOperation.addRequest(new ReplaceRequest(this.query, this.upsert, document));
    }

    public void update(DBObject update2) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, this.upsert, update2, true));
    }

    public void updateOne(DBObject update2) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, this.upsert, update2, false));
    }
}

