/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterType;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.bson.util.Assertions;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ClusterSettings {
    private final List<ServerAddress> hosts;
    private final ClusterConnectionMode mode;
    private final ClusterType requiredClusterType;
    private final String requiredReplicaSetName;

    public static Builder builder() {
        return new Builder();
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public ClusterConnectionMode getMode() {
        return this.mode;
    }

    public ClusterType getRequiredClusterType() {
        return this.requiredClusterType;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSettings that = (ClusterSettings)o;
        if (!this.hosts.equals(that.hosts)) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (this.requiredClusterType != that.requiredClusterType) {
            return false;
        }
        return !(this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that.requiredReplicaSetName) : that.requiredReplicaSetName != null);
    }

    public int hashCode() {
        int result2 = this.hosts.hashCode();
        result2 = 31 * result2 + this.mode.hashCode();
        result2 = 31 * result2 + this.requiredClusterType.hashCode();
        result2 = 31 * result2 + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "{hosts=" + this.hosts + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + '}';
    }

    public String getShortDescription() {
        return "{hosts=" + this.hosts + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + (this.requiredReplicaSetName == null ? "" : ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'') + '}';
    }

    private ClusterSettings(Builder builder) {
        Assertions.notNull("hosts", builder.hosts);
        Assertions.isTrueArgument("hosts size > 0", builder.hosts.size() > 0);
        if (builder.hosts.size() > 1 && builder.requiredClusterType == ClusterType.StandAlone) {
            throw new IllegalArgumentException("Multiple hosts cannot be specified when using ClusterType.StandAlone.");
        }
        if (builder.mode == ClusterConnectionMode.Single && builder.hosts.size() > 1) {
            throw new IllegalArgumentException("Can not directly connect to more than one server");
        }
        if (builder.requiredReplicaSetName != null) {
            if (builder.requiredClusterType == ClusterType.Unknown) {
                builder.requiredClusterType = ClusterType.ReplicaSet;
            } else if (builder.requiredClusterType != ClusterType.ReplicaSet) {
                throw new IllegalArgumentException("When specifying a replica set name, only ClusterType.Unknown and ClusterType.ReplicaSet are valid.");
            }
        }
        this.hosts = builder.hosts;
        this.mode = builder.mode;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        this.requiredClusterType = builder.requiredClusterType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Builder {
        private List<ServerAddress> hosts;
        private ClusterConnectionMode mode = ClusterConnectionMode.Multiple;
        private ClusterType requiredClusterType = ClusterType.Unknown;
        private String requiredReplicaSetName;

        private Builder() {
        }

        public Builder hosts(List<ServerAddress> hosts) {
            Assertions.notNull("hosts", hosts);
            if (hosts.isEmpty()) {
                throw new IllegalArgumentException("hosts list may not be empty");
            }
            this.hosts = Collections.unmodifiableList(new ArrayList<ServerAddress>(new LinkedHashSet<ServerAddress>(hosts)));
            return this;
        }

        public Builder mode(ClusterConnectionMode mode) {
            this.mode = Assertions.notNull("mode", mode);
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        public Builder requiredClusterType(ClusterType requiredClusterType) {
            this.requiredClusterType = Assertions.notNull("requiredClusterType", requiredClusterType);
            return this;
        }

        public ClusterSettings build() {
            return new ClusterSettings(this);
        }
    }
}

