/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.QueryOpBuilder;
import com.mongodb.QueryResultIterator;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.util.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DBCursor
implements Cursor,
Iterable<DBObject> {
    private final DBCollection _collection;
    private final DBObject _query;
    private final DBObject _keysWanted;
    private DBObject _orderBy = null;
    private String _hint = null;
    private DBObject _hintDBObj = null;
    private boolean _explain = false;
    private int _limit = 0;
    private int _batchSize = 0;
    private int _skip = 0;
    private boolean _snapshot = false;
    private int _options = 0;
    private long _maxTimeMS;
    private ReadPreference _readPref;
    private DBDecoderFactory _decoderFact;
    private DBObject _specialFields;
    private QueryResultIterator _it = null;
    private CursorType _cursorType = null;
    private DBObject _cur = null;
    private int _num = 0;
    private final ArrayList<DBObject> _all = new ArrayList();

    public DBCursor(DBCollection collection, DBObject q, DBObject k, ReadPreference preference) {
        if (collection == null) {
            throw new IllegalArgumentException("collection is null");
        }
        this._collection = collection;
        this._query = q == null ? new BasicDBObject() : q;
        this._keysWanted = k;
        this._options = this._collection.getOptions();
        this._readPref = preference;
        this._decoderFact = collection.getDBDecoderFactory();
    }

    public DBCursor comment(String comment) {
        this.addSpecial("$comment", comment);
        return this;
    }

    public DBCursor maxScan(int max2) {
        this.addSpecial("$maxScan", max2);
        return this;
    }

    public DBCursor max(DBObject max2) {
        this.addSpecial("$max", max2);
        return this;
    }

    public DBCursor min(DBObject min2) {
        this.addSpecial("$min", min2);
        return this;
    }

    public DBCursor returnKey() {
        this.addSpecial("$returnKey", true);
        return this;
    }

    public DBCursor showDiskLoc() {
        this.addSpecial("$showDiskLoc", true);
        return this;
    }

    public DBCursor copy() {
        DBCursor c = new DBCursor(this._collection, this._query, this._keysWanted, this._readPref);
        c._orderBy = this._orderBy;
        c._hint = this._hint;
        c._hintDBObj = this._hintDBObj;
        c._limit = this._limit;
        c._skip = this._skip;
        c._options = this._options;
        c._batchSize = this._batchSize;
        c._snapshot = this._snapshot;
        c._explain = this._explain;
        c._maxTimeMS = this._maxTimeMS;
        if (this._specialFields != null) {
            c._specialFields = new BasicDBObject(this._specialFields.toMap());
        }
        return c;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public DBCursor sort(DBObject orderBy) {
        if (this._it != null) {
            throw new IllegalStateException("can't sort after executing query");
        }
        this._orderBy = orderBy;
        return this;
    }

    public DBCursor addSpecial(String name, Object o) {
        if (this._specialFields == null) {
            this._specialFields = new BasicDBObject();
        }
        this._specialFields.put(name, o);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hintDBObj = indexKeys;
        return this;
    }

    public DBCursor hint(String indexName) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hint = indexName;
        return this;
    }

    public DBCursor maxTime(long maxTime, TimeUnit timeUnit) {
        this._maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public DBCursor snapshot() {
        if (this._it != null) {
            throw new IllegalStateException("can't snapshot after executing the query");
        }
        this._snapshot = true;
        return this;
    }

    public DBObject explain() {
        DBCursor c = this.copy();
        c._explain = true;
        if (c._limit > 0) {
            c._batchSize = c._limit * -1;
            c._limit = 0;
        }
        return c.next();
    }

    public DBCursor limit(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set limit after executing query");
        }
        if (n > 0) {
            this._limit = n;
        } else if (n < 0) {
            this.batchSize(n);
        }
        return this;
    }

    public DBCursor batchSize(int n) {
        if (n == 1) {
            n = 2;
        }
        if (this._it != null) {
            this._it.setBatchSize(n);
        }
        this._batchSize = n;
        return this;
    }

    public DBCursor skip(int n) {
        if (this._it != null) {
            throw new IllegalStateException("can't set skip after executing query");
        }
        this._skip = n;
        return this;
    }

    @Override
    public long getCursorId() {
        return this._it == null ? 0L : this._it.getCursorId();
    }

    @Override
    public void close() {
        if (this._it != null) {
            this._it.close();
        }
    }

    @Deprecated
    public DBCursor slaveOk() {
        return this.addOption(4);
    }

    public DBCursor addOption(int option) {
        this.setOptions(this._options |= option);
        return this;
    }

    public DBCursor setOptions(int options) {
        if ((options & 0x40) != 0) {
            throw new IllegalArgumentException("The exhaust option is not user settable.");
        }
        if ((options & 2) != 0) {
            options |= 0x20;
        }
        this._options = options;
        return this;
    }

    public DBCursor resetOptions() {
        this._options = 0;
        return this;
    }

    public int getOptions() {
        return this._options;
    }

    private void _check() {
        if (this._it != null) {
            return;
        }
        this._lookForHints();
        QueryOpBuilder builder = new QueryOpBuilder().addQuery(this._query).addOrderBy(this._orderBy).addHint(this._hintDBObj).addHint(this._hint).addExplain(this._explain).addSnapshot(this._snapshot).addSpecialFields(this._specialFields).addMaxTimeMS(this._maxTimeMS);
        if (this._collection.getDB().getMongo().isMongosConnection()) {
            builder.addReadPreference(this._readPref);
        }
        this._it = this._collection.find(builder.get(), this._keysWanted, this._skip, this._batchSize, this._limit, this._options, this._readPref, this.getDecoder());
    }

    private DBDecoder getDecoder() {
        return this._decoderFact != null ? this._decoderFact.create() : null;
    }

    private void _lookForHints() {
        if (this._hint != null) {
            return;
        }
        if (this._collection._hintFields == null) {
            return;
        }
        Set<String> mykeys = this._query.keySet();
        for (DBObject o : this._collection._hintFields) {
            Set<String> hintKeys = o.keySet();
            if (!mykeys.containsAll(hintKeys)) continue;
            this.hint(o);
            return;
        }
    }

    void _checkType(CursorType type) {
        if (this._cursorType == null) {
            this._cursorType = type;
            return;
        }
        if (type == this._cursorType) {
            return;
        }
        throw new IllegalArgumentException("can't switch cursor access methods");
    }

    private DBObject _next() {
        if (this._cursorType == null) {
            this._checkType(CursorType.ITERATOR);
        }
        this._check();
        this._cur = this._it.next();
        ++this._num;
        if (this._keysWanted != null && this._keysWanted.keySet().size() > 0) {
            this._cur.markAsPartialObject();
        }
        if (this._cursorType == CursorType.ARRAY) {
            this._all.add(this._cur);
        }
        return this._cur;
    }

    @Deprecated
    public int numGetMores() {
        return this._it == null ? 0 : this._it.numGetMores();
    }

    @Deprecated
    public List<Integer> getSizes() {
        return this._it == null ? Collections.emptyList() : this._it.getSizes();
    }

    private boolean _hasNext() {
        this._check();
        if (this._limit > 0 && this._num >= this._limit) {
            return false;
        }
        return this._it.hasNext();
    }

    public int numSeen() {
        return this._num;
    }

    @Override
    public boolean hasNext() {
        this._checkType(CursorType.ITERATOR);
        return this._hasNext();
    }

    @Override
    public DBObject next() {
        this._checkType(CursorType.ITERATOR);
        return this._next();
    }

    public DBObject curr() {
        this._checkType(CursorType.ITERATOR);
        return this._cur;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove from a cursor");
    }

    void _fill(int n) {
        this._checkType(CursorType.ARRAY);
        while (n >= this._all.size() && this._hasNext()) {
            this._next();
        }
    }

    public int length() {
        this._checkType(CursorType.ARRAY);
        this._fill(Integer.MAX_VALUE);
        return this._all.size();
    }

    public List<DBObject> toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max2) {
        this._checkType(CursorType.ARRAY);
        this._fill(max2 - 1);
        return this._all;
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int count() {
        return (int)this._collection.getCount(this._query, this._keysWanted, 0L, 0L, this.getReadPreference(), this._maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBObject one() {
        return this._collection.findOne(this._query, this._keysWanted, this._orderBy, this.getReadPreference(), this._maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public int size() {
        return (int)this._collection.getCount(this._query, this._keysWanted, this._limit, this._skip, this.getReadPreference(), this._maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DBObject getKeysWanted() {
        return this._keysWanted;
    }

    public DBObject getQuery() {
        return this._query;
    }

    public DBCollection getCollection() {
        return this._collection;
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._it == null ? null : this._it.getServerAddress();
    }

    public DBCursor setReadPreference(ReadPreference preference) {
        this._readPref = preference;
        return this;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }

    public DBCursor setDecoderFactory(DBDecoderFactory fact) {
        this._decoderFact = fact;
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this._decoderFact;
    }

    public String toString() {
        ServerAddress addr;
        StringBuilder sb = new StringBuilder();
        sb.append("Cursor id=").append(this.getCursorId());
        sb.append(", ns=").append(this.getCollection().getFullName());
        sb.append(", query=").append(this.getQuery());
        if (this.getKeysWanted() != null) {
            sb.append(", fields=").append(this.getKeysWanted());
        }
        sb.append(", numIterated=").append(this._num);
        if (this._skip != 0) {
            sb.append(", skip=").append(this._skip);
        }
        if (this._limit != 0) {
            sb.append(", limit=").append(this._limit);
        }
        if (this._batchSize != 0) {
            sb.append(", batchSize=").append(this._batchSize);
        }
        if ((addr = this.getServerAddress()) != null) {
            sb.append(", addr=").append(addr);
        }
        if (this._readPref != null) {
            sb.append(", readPreference=").append(this._readPref.toString());
        }
        return sb.toString();
    }

    boolean hasFinalizer() {
        if (this._it == null) {
            return false;
        }
        return this._it.hasFinalizer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorType {
        ITERATOR,
        ARRAY;

    }
}

