/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import javax.net.SocketFactory;
import org.bson.util.annotations.Immutable;

@Immutable
public class MongoClientOptions {
    private final String description;
    private final int minConnectionsPerHost;
    private final int connectionsPerHost;
    private final int threadsAllowedToBlockForConnectionMultiplier;
    private final int maxWaitTime;
    private final int maxConnectionIdleTime;
    private final int maxConnectionLifeTime;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean socketKeepAlive;
    private final boolean autoConnectRetry;
    private final long maxAutoConnectRetryTime;
    private final ReadPreference readPreference;
    private final DBDecoderFactory dbDecoderFactory;
    private final DBEncoderFactory dbEncoderFactory;
    private final WriteConcern writeConcern;
    private final SocketFactory socketFactory;
    private final boolean cursorFinalizerEnabled;
    private final boolean alwaysUseMBeans;
    private final int heartbeatFrequency;
    private final int heartbeatConnectRetryFrequency;
    private final int heartbeatConnectTimeout;
    private final int heartbeatSocketTimeout;
    private final int heartbeatThreadCount;
    private final int acceptableLatencyDifference;
    private final String requiredReplicaSetName;

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public int getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    @Deprecated
    public boolean isAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    @Deprecated
    public long getMaxAutoConnectRetryTime() {
        return this.maxAutoConnectRetryTime;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    public boolean isAlwaysUseMBeans() {
        return this.alwaysUseMBeans;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public int getHeartbeatConnectRetryFrequency() {
        return this.heartbeatConnectRetryFrequency;
    }

    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectTimeout;
    }

    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    public int getHeartbeatThreadCount() {
        return this.heartbeatThreadCount;
    }

    public int getAcceptableLatencyDifference() {
        return this.acceptableLatencyDifference;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientOptions that = (MongoClientOptions)o;
        if (this.acceptableLatencyDifference != that.acceptableLatencyDifference) {
            return false;
        }
        if (this.alwaysUseMBeans != that.alwaysUseMBeans) {
            return false;
        }
        if (this.autoConnectRetry != that.autoConnectRetry) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.connectionsPerHost != that.connectionsPerHost) {
            return false;
        }
        if (this.cursorFinalizerEnabled != that.cursorFinalizerEnabled) {
            return false;
        }
        if (this.heartbeatConnectRetryFrequency != that.heartbeatConnectRetryFrequency) {
            return false;
        }
        if (this.heartbeatConnectTimeout != that.heartbeatConnectTimeout) {
            return false;
        }
        if (this.heartbeatFrequency != that.heartbeatFrequency) {
            return false;
        }
        if (this.heartbeatSocketTimeout != that.heartbeatSocketTimeout) {
            return false;
        }
        if (this.heartbeatThreadCount != that.heartbeatThreadCount) {
            return false;
        }
        if (this.maxAutoConnectRetryTime != that.maxAutoConnectRetryTime) {
            return false;
        }
        if (this.maxConnectionIdleTime != that.maxConnectionIdleTime) {
            return false;
        }
        if (this.maxConnectionLifeTime != that.maxConnectionLifeTime) {
            return false;
        }
        if (this.maxWaitTime != that.maxWaitTime) {
            return false;
        }
        if (this.minConnectionsPerHost != that.minConnectionsPerHost) {
            return false;
        }
        if (this.socketKeepAlive != that.socketKeepAlive) {
            return false;
        }
        if (this.socketTimeout != that.socketTimeout) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != that.threadsAllowedToBlockForConnectionMultiplier) {
            return false;
        }
        if (!this.dbDecoderFactory.equals(that.dbDecoderFactory)) {
            return false;
        }
        if (!this.dbEncoderFactory.equals(that.dbEncoderFactory)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.readPreference.equals(that.readPreference)) {
            return false;
        }
        if (!this.socketFactory.getClass().equals(that.socketFactory.getClass())) {
            return false;
        }
        if (!this.writeConcern.equals(that.writeConcern)) {
            return false;
        }
        return !(this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that.requiredReplicaSetName) : that.requiredReplicaSetName != null);
    }

    public int hashCode() {
        int result2 = this.description != null ? this.description.hashCode() : 0;
        result2 = 31 * result2 + this.minConnectionsPerHost;
        result2 = 31 * result2 + this.connectionsPerHost;
        result2 = 31 * result2 + this.threadsAllowedToBlockForConnectionMultiplier;
        result2 = 31 * result2 + this.maxWaitTime;
        result2 = 31 * result2 + this.maxConnectionIdleTime;
        result2 = 31 * result2 + this.maxConnectionLifeTime;
        result2 = 31 * result2 + this.connectTimeout;
        result2 = 31 * result2 + this.socketTimeout;
        result2 = 31 * result2 + (this.socketKeepAlive ? 1 : 0);
        result2 = 31 * result2 + (this.autoConnectRetry ? 1 : 0);
        result2 = 31 * result2 + (int)(this.maxAutoConnectRetryTime ^ this.maxAutoConnectRetryTime >>> 32);
        result2 = 31 * result2 + this.readPreference.hashCode();
        result2 = 31 * result2 + this.dbDecoderFactory.hashCode();
        result2 = 31 * result2 + this.dbEncoderFactory.hashCode();
        result2 = 31 * result2 + this.writeConcern.hashCode();
        result2 = 31 * result2 + (this.socketFactory != null ? this.socketFactory.getClass().hashCode() : 0);
        result2 = 31 * result2 + (this.cursorFinalizerEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.alwaysUseMBeans ? 1 : 0);
        result2 = 31 * result2 + this.heartbeatFrequency;
        result2 = 31 * result2 + this.heartbeatConnectRetryFrequency;
        result2 = 31 * result2 + this.heartbeatConnectTimeout;
        result2 = 31 * result2 + this.heartbeatSocketTimeout;
        result2 = 31 * result2 + this.heartbeatThreadCount;
        result2 = 31 * result2 + this.acceptableLatencyDifference;
        result2 = 31 * result2 + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "MongoClientOptions{description='" + this.description + '\'' + ", connectionsPerHost=" + this.connectionsPerHost + ", threadsAllowedToBlockForConnectionMultiplier=" + this.threadsAllowedToBlockForConnectionMultiplier + ", maxWaitTime=" + this.maxWaitTime + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", socketKeepAlive=" + this.socketKeepAlive + ", autoConnectRetry=" + this.autoConnectRetry + ", maxAutoConnectRetryTime=" + this.maxAutoConnectRetryTime + ", readPreference=" + this.readPreference + ", dbDecoderFactory=" + this.dbDecoderFactory + ", dbEncoderFactory=" + this.dbEncoderFactory + ", writeConcern=" + this.writeConcern + ", socketFactory=" + this.socketFactory + ", cursorFinalizerEnabled=" + this.cursorFinalizerEnabled + ", alwaysUseMBeans=" + this.alwaysUseMBeans + ", heartbeatFrequency=" + this.heartbeatFrequency + ", heartbeatConnectRetryFrequency=" + this.heartbeatConnectRetryFrequency + ", heartbeatConnectTimeout=" + this.heartbeatConnectTimeout + ", heartbeatSocketTimeout=" + this.heartbeatSocketTimeout + ", heartbeatThreadCount=" + this.heartbeatThreadCount + ", acceptableLatencyDifference=" + this.acceptableLatencyDifference + ", requiredReplicaSetName=" + this.requiredReplicaSetName + '}';
    }

    private MongoClientOptions(Builder builder) {
        this.description = builder.description;
        this.minConnectionsPerHost = builder.minConnectionsPerHost;
        this.connectionsPerHost = builder.connectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = builder.threadsAllowedToBlockForConnectionMultiplier;
        this.maxWaitTime = builder.maxWaitTime;
        this.maxConnectionIdleTime = builder.maxConnectionIdleTime;
        this.maxConnectionLifeTime = builder.maxConnectionLifeTime;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.autoConnectRetry = builder.autoConnectRetry;
        this.socketKeepAlive = builder.socketKeepAlive;
        this.maxAutoConnectRetryTime = builder.maxAutoConnectRetryTime;
        this.readPreference = builder.readPreference;
        this.dbDecoderFactory = builder.dbDecoderFactory;
        this.dbEncoderFactory = builder.dbEncoderFactory;
        this.writeConcern = builder.writeConcern;
        this.socketFactory = builder.socketFactory;
        this.cursorFinalizerEnabled = builder.cursorFinalizerEnabled;
        this.alwaysUseMBeans = builder.alwaysUseMBeans;
        this.heartbeatFrequency = builder.heartbeatFrequency;
        this.heartbeatConnectRetryFrequency = builder.heartbeatConnectRetryFrequency;
        this.heartbeatConnectTimeout = builder.heartbeatConnectTimeout;
        this.heartbeatSocketTimeout = builder.heartbeatSocketTimeout;
        this.heartbeatThreadCount = builder.heartbeatThreadCount;
        this.acceptableLatencyDifference = builder.acceptableLatencyDifference;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
    }

    public static class Builder {
        private String description;
        private int minConnectionsPerHost;
        private int connectionsPerHost = 100;
        private int threadsAllowedToBlockForConnectionMultiplier = 5;
        private int maxWaitTime = 120000;
        private int maxConnectionIdleTime;
        private int maxConnectionLifeTime;
        private int connectTimeout = 10000;
        private int socketTimeout = 0;
        private boolean socketKeepAlive = false;
        private boolean autoConnectRetry = false;
        private long maxAutoConnectRetryTime = 0L;
        private ReadPreference readPreference = ReadPreference.primary();
        private DBDecoderFactory dbDecoderFactory = DefaultDBDecoder.FACTORY;
        private DBEncoderFactory dbEncoderFactory = DefaultDBEncoder.FACTORY;
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private boolean cursorFinalizerEnabled = true;
        private boolean alwaysUseMBeans = false;
        private int heartbeatFrequency = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000"));
        private int heartbeatConnectRetryFrequency = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "10"));
        private int heartbeatConnectTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000"));
        private int heartbeatSocketTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000"));
        private int heartbeatThreadCount;
        private int acceptableLatencyDifference = Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15"));
        private String requiredReplicaSetName;

        public Builder heartbeatFrequency(int heartbeatFrequency) {
            if (heartbeatFrequency < 1) {
                throw new IllegalArgumentException("heartbeatFrequency must be greater than 0");
            }
            this.heartbeatFrequency = heartbeatFrequency;
            return this;
        }

        public Builder heartbeatConnectRetryFrequency(int heartbeatConnectRetryFrequency) {
            if (heartbeatConnectRetryFrequency < 1) {
                throw new IllegalArgumentException("heartbeatConnectRetryFrequency must be greater than 0");
            }
            this.heartbeatConnectRetryFrequency = heartbeatConnectRetryFrequency;
            return this;
        }

        public Builder heartbeatConnectTimeout(int heartbeatConnectTimeout) {
            if (heartbeatConnectTimeout < 0) {
                throw new IllegalArgumentException("heartbeatConnectTimeout must be greater than or equal to 0");
            }
            this.heartbeatConnectTimeout = heartbeatConnectTimeout;
            return this;
        }

        public Builder heartbeatSocketTimeout(int heartbeatSocketTimeout) {
            if (heartbeatSocketTimeout < 0) {
                throw new IllegalArgumentException("heartbeatSocketTimeout must be greater than or equal to 0");
            }
            this.heartbeatSocketTimeout = heartbeatSocketTimeout;
            return this;
        }

        public Builder heartbeatThreadCount(int heartbeatThreadCount) {
            if (heartbeatThreadCount < 1) {
                throw new IllegalArgumentException("heartbeatThreadCount must be greater than 0");
            }
            this.heartbeatThreadCount = heartbeatThreadCount;
            return this;
        }

        public Builder acceptableLatencyDifference(int acceptableLatencyDifference) {
            if (acceptableLatencyDifference < 0) {
                throw new IllegalArgumentException("acceptableLatencyDifference must be greater than or equal to 0");
            }
            this.acceptableLatencyDifference = acceptableLatencyDifference;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder minConnectionsPerHost(int minConnectionsPerHost) {
            if (minConnectionsPerHost < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.minConnectionsPerHost = minConnectionsPerHost;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            if (connectionsPerHost < 1) {
                throw new IllegalArgumentException("Minimum value is 1");
            }
            this.connectionsPerHost = connectionsPerHost;
            return this;
        }

        public Builder threadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
            if (threadsAllowedToBlockForConnectionMultiplier < 1) {
                throw new IllegalArgumentException("Minimum value is 1");
            }
            this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
            return this;
        }

        public Builder maxWaitTime(int maxWaitTime) {
            if (maxWaitTime < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder maxConnectionIdleTime(int maxConnectionIdleTime) {
            if (maxConnectionIdleTime < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxConnectionIdleTime = maxConnectionIdleTime;
            return this;
        }

        public Builder maxConnectionLifeTime(int maxConnectionLifeTime) {
            if (maxConnectionLifeTime < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxConnectionLifeTime = maxConnectionLifeTime;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            if (socketTimeout < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return this;
        }

        @Deprecated
        public Builder autoConnectRetry(boolean autoConnectRetry) {
            this.autoConnectRetry = autoConnectRetry;
            return this;
        }

        @Deprecated
        public Builder maxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
            if (maxAutoConnectRetryTime < 0L) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            if (readPreference == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.readPreference = readPreference;
            return this;
        }

        public Builder dbDecoderFactory(DBDecoderFactory dbDecoderFactory) {
            if (dbDecoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbDecoderFactory = dbDecoderFactory;
            return this;
        }

        public Builder dbEncoderFactory(DBEncoderFactory dbEncoderFactory) {
            if (dbEncoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbEncoderFactory = dbEncoderFactory;
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            if (writeConcern == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.writeConcern = writeConcern;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder cursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
            this.cursorFinalizerEnabled = cursorFinalizerEnabled;
            return this;
        }

        public Builder alwaysUseMBeans(boolean alwaysUseMBeans) {
            this.alwaysUseMBeans = alwaysUseMBeans;
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        public Builder legacyDefaults() {
            this.connectionsPerHost = 10;
            this.writeConcern = WriteConcern.NORMAL;
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

