/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class MongoCredential {
    public static final String MONGODB_CR_MECHANISM = "MONGODB-CR";
    public static final String GSSAPI_MECHANISM = "GSSAPI";
    public static final String PLAIN_MECHANISM = "PLAIN";
    public static final String MONGODB_X509_MECHANISM = "MONGODB-X509";
    private final String mechanism;
    private final String userName;
    private final String source;
    private final char[] password;
    private final Map<String, Object> mechanismProperties;

    public static MongoCredential createMongoCRCredential(String userName, String database, char[] password) {
        return new MongoCredential(MONGODB_CR_MECHANISM, userName, database, password);
    }

    public static MongoCredential createGSSAPICredential(String userName) {
        return new MongoCredential(GSSAPI_MECHANISM, userName, "$external", null);
    }

    public static MongoCredential createMongoX509Credential(String userName) {
        return new MongoCredential(MONGODB_X509_MECHANISM, userName, "$external", null);
    }

    public static MongoCredential createPlainCredential(String userName, String source, char[] password) {
        return new MongoCredential(PLAIN_MECHANISM, userName, source, password);
    }

    public <T> MongoCredential withMechanismProperty(String key, T value) {
        return new MongoCredential(this, key, value);
    }

    MongoCredential(String mechanism, String userName, String source, char[] password) {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism can not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("username can not be null");
        }
        if (mechanism.equals(MONGODB_CR_MECHANISM) && password == null) {
            throw new IllegalArgumentException("Password can not be null for MONGODB-CR mechanism");
        }
        if (mechanism.equals(GSSAPI_MECHANISM) && password != null) {
            throw new IllegalArgumentException("Password must be null for the GSSAPI mechanism");
        }
        this.mechanism = mechanism;
        this.userName = userName;
        this.source = source;
        this.password = password != null ? (char[])password.clone() : null;
        this.mechanismProperties = Collections.emptyMap();
    }

    <T> MongoCredential(MongoCredential from2, String mechanismPropertyKey, T mechanismPropertyValue) {
        this.mechanism = from2.mechanism;
        this.userName = from2.userName;
        this.source = from2.source;
        this.password = from2.password;
        this.mechanismProperties = new HashMap<String, Object>(from2.mechanismProperties);
        this.mechanismProperties.put(mechanismPropertyKey, mechanismPropertyValue);
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSource() {
        return this.source;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return (char[])this.password.clone();
    }

    public <T> T getMechanismProperty(String key, T defaultValue) {
        Object value = this.mechanismProperties.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoCredential that = (MongoCredential)o;
        if (!this.mechanism.equals(that.mechanism)) {
            return false;
        }
        if (!Arrays.equals(this.password, that.password)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.userName.equals(that.userName)) {
            return false;
        }
        return this.mechanismProperties.equals(that.mechanismProperties);
    }

    public int hashCode() {
        int result2 = this.mechanism.hashCode();
        result2 = 31 * result2 + this.userName.hashCode();
        result2 = 31 * result2 + this.source.hashCode();
        result2 = 31 * result2 + (this.password != null ? Arrays.hashCode(this.password) : 0);
        result2 = 31 * result2 + this.mechanismProperties.hashCode();
        return result2;
    }

    public String toString() {
        return "MongoCredential{mechanism='" + this.mechanism + '\'' + ", userName='" + this.userName + '\'' + ", source='" + this.source + '\'' + ", password=<hidden>" + ", mechanismProperties=" + this.mechanismProperties + '}';
    }
}

