/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Cursor;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBCollectionImpl;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultIterator
implements Cursor {
    private final DBApiLayer _db;
    private final DBDecoder _decoder;
    private final DBCollectionImpl _collection;
    private final int _options;
    private final ServerAddress _host;
    private final int _limit;
    private long _cursorId;
    private Iterator<DBObject> _cur;
    private int _curSize;
    private int _batchSize;
    private boolean closed;
    private final List<Integer> _sizes = new ArrayList<Integer>();
    private int _numGetMores = 0;
    private int _numFetched = 0;
    private final OptionalFinalizer _optionalFinalizer;

    QueryResultIterator(DBApiLayer db, DBCollectionImpl collection, Response res, int batchSize, int limit, int options, DBDecoder decoder) {
        this._db = db;
        this._collection = collection;
        this._batchSize = batchSize;
        this._limit = limit;
        this._options = options;
        this._host = res._host;
        this._decoder = decoder;
        this.initFromQueryResponse(res);
        this._optionalFinalizer = this.getOptionalFinalizer(collection);
    }

    QueryResultIterator(DBObject cursorDocument, DBApiLayer db, DBCollectionImpl collection, int batchSize, DBDecoder decoder, ServerAddress serverAddress) {
        this._db = db;
        this._collection = collection;
        this._batchSize = batchSize;
        this._host = serverAddress;
        this._limit = 0;
        this._options = 0;
        this._decoder = decoder;
        this.initFromCursorDocument(cursorDocument);
        this._optionalFinalizer = this.getOptionalFinalizer(collection);
    }

    static int chooseBatchSize(int batchSize, int limit, int fetched) {
        int remaining;
        int bs = Math.abs(batchSize);
        int n = remaining = limit > 0 ? limit - fetched : 0;
        int res = bs == 0 && remaining > 0 ? remaining : (bs > 0 && remaining == 0 ? bs : Math.min(bs, remaining));
        if (batchSize < 0) {
            res = -res;
        }
        if (res == 1) {
            res = -1;
        }
        return res;
    }

    @Override
    public DBObject next() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._cur.next();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed");
        }
        if (this._cur.hasNext()) {
            return true;
        }
        while (this._cursorId != 0L) {
            this.getMore();
            if (this._curSize <= 0) continue;
            return true;
        }
        return false;
    }

    private void getMore() {
        Response res = this._db._connector.call(this._collection.getDB(), (DBCollection)this._collection, OutMessage.getMore(this._collection, this._cursorId, this.getGetMoreBatchSize()), this._host, this._decoder);
        ++this._numGetMores;
        this.initFromQueryResponse(res);
    }

    private int getGetMoreBatchSize() {
        return QueryResultIterator.chooseBatchSize(this._batchSize, this._limit, this._numFetched);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove a document via a query result iterator");
    }

    public void setBatchSize(int size2) {
        this._batchSize = size2;
    }

    @Override
    public long getCursorId() {
        return this._cursorId;
    }

    int numGetMores() {
        return this._numGetMores;
    }

    List<Integer> getSizes() {
        return Collections.unmodifiableList(this._sizes);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.killCursor();
        }
    }

    private void initFromQueryResponse(Response response) {
        this.init(response._flags, response.cursor(), response.size(), response.iterator());
    }

    private void initFromCursorDocument(DBObject cursorDocument) {
        Map cursor = (Map)cursorDocument.get("cursor");
        if (cursor != null) {
            long cursorId = (Long)cursor.get("id");
            List firstBatch = (List)cursor.get("firstBatch");
            this.init(0, cursorId, firstBatch.size(), firstBatch.iterator());
        } else {
            List result2 = (List)cursorDocument.get("result");
            this.init(0, 0L, result2.size(), result2.iterator());
        }
    }

    private void init(int flags, long cursorId, int size2, Iterator<DBObject> iterator2) {
        this._curSize = size2;
        this._cur = iterator2;
        this._sizes.add(size2);
        this._numFetched += size2;
        this.throwOnQueryFailure(this._cursorId, flags);
        this._cursorId = cursorId;
        if (cursorId != 0L && this._limit > 0 && this._limit - this._numFetched <= 0) {
            this.killCursor();
        }
    }

    private void throwOnQueryFailure(long cursorId, int flags) {
        if ((flags & 2) > 0) {
            BSONObject errorDocument = this._cur.next();
            if (ServerError.getCode(errorDocument) == 50) {
                throw new MongoExecutionTimeoutException(ServerError.getCode(errorDocument), ServerError.getMsg(errorDocument, null));
            }
            throw new MongoException(ServerError.getCode(errorDocument), ServerError.getMsg(errorDocument, null));
        }
        if ((flags & 1) > 0) {
            throw new MongoException.CursorNotFound(cursorId, this._host);
        }
    }

    void killCursor() {
        if (this._cursorId == 0L) {
            return;
        }
        try {
            this._db.killCursors(this._host, Arrays.asList(this._cursorId));
            this._cursorId = 0L;
        }
        catch (MongoException e) {
            this._db.addDeadCursor(new DBApiLayer.DeadCursor(this._cursorId, this._host));
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._host;
    }

    boolean hasFinalizer() {
        return this._optionalFinalizer != null;
    }

    private OptionalFinalizer getOptionalFinalizer(DBCollectionImpl coll) {
        return coll.getDB().getMongo().getMongoOptions().isCursorFinalizerEnabled() && this._cursorId != 0L ? new OptionalFinalizer() : null;
    }

    private class OptionalFinalizer {
        private OptionalFinalizer() {
        }

        protected void finalize() throws Throwable {
            if (!QueryResultIterator.this.closed && QueryResultIterator.this._cursorId != 0L) {
                QueryResultIterator.this._db.addDeadCursor(new DBApiLayer.DeadCursor(QueryResultIterator.this._cursorId, QueryResultIterator.this._host));
            }
            super.finalize();
        }
    }
}

