/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.bson.util.annotations.Immutable;

@Immutable
public class ServerAddress {
    final String _host;
    final int _port;

    public ServerAddress() throws UnknownHostException {
        this(ServerAddress.defaultHost(), ServerAddress.defaultPort());
    }

    public ServerAddress(String host) throws UnknownHostException {
        this(host, ServerAddress.defaultPort());
    }

    public ServerAddress(String host, int port) throws UnknownHostException {
        if (host == null) {
            host = ServerAddress.defaultHost();
        }
        if ((host = host.trim()).length() == 0) {
            host = ServerAddress.defaultHost();
        }
        if (host.startsWith("[")) {
            int idx = host.indexOf("]");
            if (idx == -1) {
                throw new IllegalArgumentException("an IPV6 address must be encosed with '[' and ']' according to RFC 2732.");
            }
            int portIdx = host.indexOf("]:");
            if (portIdx != -1) {
                if (port != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                port = Integer.parseInt(host.substring(portIdx + 2));
            }
            host = host.substring(1, idx);
        } else {
            int idx = host.indexOf(":");
            if (idx > 0) {
                if (port != ServerAddress.defaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                port = Integer.parseInt(host.substring(idx + 1));
                host = host.substring(0, idx).trim();
            }
        }
        this._host = host;
        this._port = port;
    }

    public ServerAddress(InetAddress addr) {
        this(new InetSocketAddress(addr, ServerAddress.defaultPort()));
    }

    public ServerAddress(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public ServerAddress(InetSocketAddress addr) {
        this._host = addr.getHostName();
        this._port = addr.getPort();
    }

    public boolean sameHost(String host) {
        int idx = host.indexOf(":");
        int port = ServerAddress.defaultPort();
        if (idx > 0) {
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        return this._port == port && this._host.equalsIgnoreCase(host);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this._port != that._port) {
            return false;
        }
        return this._host.equals(that._host);
    }

    public int hashCode() {
        int result2 = this._host.hashCode();
        result2 = 31 * result2 + this._port;
        return result2;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public InetSocketAddress getSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getByName(this._host), this._port);
    }

    public String toString() {
        return this._host + ":" + this._port;
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }
}

