/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bson.types.ObjectId;

public class GridFSInputFile
extends GridFSFile {
    private final InputStream _in;
    private boolean _closeStreamOnPersist;
    private boolean _savedChunks = false;
    private byte[] _buffer = null;
    private int _currentChunkNumber = 0;
    private int _currentBufferPosition = 0;
    private long _totalBytes = 0L;
    private MessageDigest _messageDigester = null;
    private OutputStream _outputStream = null;

    protected GridFSInputFile(GridFS fs, InputStream in, String filename, boolean closeStreamOnPersist) {
        this._fs = fs;
        this._in = in;
        this._filename = filename;
        this._closeStreamOnPersist = closeStreamOnPersist;
        this._id = new ObjectId();
        this._chunkSize = 261120L;
        this._uploadDate = new Date();
        try {
            this._messageDigester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5!");
        }
        this._messageDigester.reset();
        this._buffer = new byte[(int)this._chunkSize];
    }

    protected GridFSInputFile(GridFS fs, InputStream in, String filename) {
        this(fs, in, filename, false);
    }

    protected GridFSInputFile(GridFS fs, String filename) {
        this(fs, null, filename);
    }

    protected GridFSInputFile(GridFS fs) {
        this(fs, null, null);
    }

    public void setId(Object id) {
        this._id = id;
    }

    public void setFilename(String fn) {
        this._filename = fn;
    }

    public void setContentType(String ct) {
        this._contentType = ct;
    }

    public void setChunkSize(long chunkSize) {
        if (this._outputStream != null || this._savedChunks) {
            return;
        }
        this._chunkSize = chunkSize;
        this._buffer = new byte[(int)this._chunkSize];
    }

    public void save() {
        this.save(this._chunkSize);
    }

    public void save(long chunkSize) {
        if (this._outputStream != null) {
            throw new MongoException("cannot mix OutputStream and regular save()");
        }
        if (!this._savedChunks) {
            try {
                this.saveChunks(chunkSize);
            }
            catch (IOException ioe) {
                throw new MongoException("couldn't save chunks", ioe);
            }
        }
        super.save();
    }

    public int saveChunks() throws IOException {
        return this.saveChunks(this._chunkSize);
    }

    public int saveChunks(long chunkSize) throws IOException {
        if (this._outputStream != null) {
            throw new MongoException("cannot mix OutputStream and regular save()");
        }
        if (this._savedChunks) {
            throw new MongoException("chunks already saved!");
        }
        if (chunkSize <= 0L) {
            throw new MongoException("chunkSize must be greater than zero");
        }
        if (this._chunkSize != chunkSize) {
            this._chunkSize = chunkSize;
            this._buffer = new byte[(int)this._chunkSize];
        }
        int bytesRead = 0;
        while (bytesRead >= 0) {
            this._currentBufferPosition = 0;
            bytesRead = this._readStream2Buffer();
            this._dumpBuffer(true);
        }
        this._finishData();
        return this._currentChunkNumber;
    }

    public OutputStream getOutputStream() {
        if (this._outputStream == null) {
            this._outputStream = new MyOutputStream();
        }
        return this._outputStream;
    }

    private void _dumpBuffer(boolean writePartial) {
        if ((long)this._currentBufferPosition < this._chunkSize && !writePartial) {
            return;
        }
        if (this._currentBufferPosition == 0) {
            return;
        }
        byte[] writeBuffer = this._buffer;
        if ((long)this._currentBufferPosition != this._chunkSize) {
            writeBuffer = new byte[this._currentBufferPosition];
            System.arraycopy(this._buffer, 0, writeBuffer, 0, this._currentBufferPosition);
        }
        DBObject chunk = this.createChunk(this._id, this._currentChunkNumber, writeBuffer);
        this._fs._chunkCollection.save(chunk);
        ++this._currentChunkNumber;
        this._totalBytes += (long)writeBuffer.length;
        this._messageDigester.update(writeBuffer);
        this._currentBufferPosition = 0;
    }

    protected DBObject createChunk(Object id, int currentChunkNumber, byte[] writeBuffer) {
        return BasicDBObjectBuilder.start().add("files_id", id).add("n", currentChunkNumber).add("data", writeBuffer).get();
    }

    private int _readStream2Buffer() throws IOException {
        int bytesRead = 0;
        while ((long)this._currentBufferPosition < this._chunkSize && bytesRead >= 0) {
            bytesRead = this._in.read(this._buffer, this._currentBufferPosition, (int)this._chunkSize - this._currentBufferPosition);
            if (bytesRead > 0) {
                this._currentBufferPosition += bytesRead;
                continue;
            }
            if (bytesRead != 0) continue;
            throw new RuntimeException("i'm doing something wrong");
        }
        return bytesRead;
    }

    private void _finishData() {
        if (!this._savedChunks) {
            this._md5 = Util.toHex(this._messageDigester.digest());
            this._messageDigester = null;
            this._length = this._totalBytes;
            this._savedChunks = true;
            try {
                if (this._in != null && this._closeStreamOnPersist) {
                    this._in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class MyOutputStream
    extends OutputStream {
        MyOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] byteArray = new byte[]{(byte)(b & 0xFF)};
            this.write(byteArray, 0, 1);
        }

        public void write(byte[] b, int off, int len2) throws IOException {
            int offset = off;
            int toCopy = 0;
            for (int length = len2; length > 0; length -= toCopy) {
                toCopy = length;
                if ((long)toCopy > GridFSInputFile.this._chunkSize - (long)GridFSInputFile.this._currentBufferPosition) {
                    toCopy = (int)GridFSInputFile.this._chunkSize - GridFSInputFile.this._currentBufferPosition;
                }
                System.arraycopy(b, offset, GridFSInputFile.this._buffer, GridFSInputFile.this._currentBufferPosition, toCopy);
                GridFSInputFile.this._currentBufferPosition += toCopy;
                offset += toCopy;
                if ((long)GridFSInputFile.this._currentBufferPosition != GridFSInputFile.this._chunkSize) continue;
                GridFSInputFile.this._dumpBuffer(false);
            }
        }

        public void close() {
            GridFSInputFile.this._dumpBuffer(true);
            GridFSInputFile.this._finishData();
            GridFSInputFile.super.save();
        }
    }
}

