/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

@Deprecated
public final class StringParseUtil {
    public static boolean parseBoolean(String s2, boolean d) {
        if (s2 == null) {
            return d;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return d;
        }
        char c = s2.charAt(0);
        if (c == 't' || c == 'T' || c == 'y' || c == 'Y') {
            return true;
        }
        if (c == 'f' || c == 'F' || c == 'n' || c == 'N') {
            return false;
        }
        return d;
    }

    public static int parseInt(String s2, int def) {
        return StringParseUtil.parseInt(s2, def, null, true);
    }

    public static Number parseIntRadix(String s2, int radix) {
        if (s2 == null) {
            return Double.NaN;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return Double.NaN;
        }
        int firstDigit = -1;
        int i = 0;
        if (s2.charAt(0) == '-') {
            i = 1;
        }
        while (i < s2.length() && Character.digit(s2.charAt(i), radix) != -1) {
            ++i;
        }
        try {
            return Long.valueOf(s2.substring(0, i), radix);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static int parseInt(String s2, int def, int[] lastIdx, boolean allowNegative) {
        int lastDigit;
        boolean useLastIdx;
        boolean bl = useLastIdx = lastIdx != null && lastIdx.length > 0;
        if (useLastIdx) {
            lastIdx[0] = -1;
        }
        if (s2 == null) {
            return def;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return def;
        }
        int firstDigit = -1;
        for (int i = 0; i < s2.length(); ++i) {
            if (!Character.isDigit(s2.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit < 0) {
            return def;
        }
        for (lastDigit = firstDigit + 1; lastDigit < s2.length() && Character.isDigit(s2.charAt(lastDigit)); ++lastDigit) {
        }
        if (allowNegative && firstDigit > 0 && s2.charAt(firstDigit - 1) == '-') {
            --firstDigit;
        }
        if (useLastIdx) {
            lastIdx[0] = lastDigit;
        }
        return Integer.parseInt(s2.substring(firstDigit, lastDigit));
    }

    public static Number parseNumber(String s2, Number def) {
        int lastDigit;
        if (s2 == null) {
            return def;
        }
        if ((s2 = s2.trim()).length() == 0) {
            return def;
        }
        int firstDigit = -1;
        for (int i = 0; i < s2.length(); ++i) {
            if (!Character.isDigit(s2.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit < 0) {
            return def;
        }
        for (lastDigit = firstDigit + 1; lastDigit < s2.length() && Character.isDigit(s2.charAt(lastDigit)); ++lastDigit) {
        }
        boolean isDouble = false;
        if (firstDigit > 0 && s2.charAt(firstDigit - 1) == '.') {
            --firstDigit;
            isDouble = true;
        }
        if (firstDigit > 0 && s2.charAt(firstDigit - 1) == '-') {
            --firstDigit;
        }
        if (lastDigit < s2.length() && s2.charAt(lastDigit) == '.') {
            ++lastDigit;
            while (lastDigit < s2.length() && Character.isDigit(s2.charAt(lastDigit))) {
                ++lastDigit;
            }
            isDouble = true;
        }
        if (lastDigit < s2.length() && s2.charAt(lastDigit) == 'E') {
            ++lastDigit;
            while (lastDigit < s2.length() && Character.isDigit(s2.charAt(lastDigit))) {
                ++lastDigit;
            }
            isDouble = true;
        }
        String actual = s2.substring(firstDigit, lastDigit);
        if (isDouble || actual.length() > 17) {
            return Double.valueOf(actual);
        }
        if (actual.length() > 10) {
            return Long.valueOf(actual);
        }
        return Integer.valueOf(actual);
    }

    public static Number parseStrict(String s2) {
        if (s2.length() == 0) {
            return 0;
        }
        if (s2.charAt(0) == '+') {
            s2 = s2.substring(1);
        }
        if (s2.matches("(\\+|-)?Infinity")) {
            if (s2.startsWith("-")) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (s2.indexOf(46) != -1 || s2.equals("-0")) {
            return Double.valueOf(s2);
        }
        if (s2.toLowerCase().indexOf("0x") > -1) {
            int coef;
            int n = coef = s2.charAt(0) == '-' ? -1 : 1;
            if (s2.length() > 17) {
                throw new RuntimeException("Can't handle a number this big: " + s2);
            }
            if (s2.length() > 9) {
                return (long)coef * Long.valueOf(s2.substring((int)((double)coef * -0.5 + 2.5)), 16);
            }
            return coef * Integer.valueOf(s2.substring((int)((double)coef * -0.5 + 2.5)), 16);
        }
        int e = s2.toLowerCase().indexOf(101);
        if (e > 0) {
            double num = Double.parseDouble(s2.substring(0, e));
            int exp = Integer.parseInt(s2.substring(e + 1));
            return num * Math.pow(10.0, exp);
        }
        if (s2.length() > 17) {
            return Double.valueOf(s2);
        }
        if (s2.length() > 9) {
            return Long.valueOf(s2);
        }
        return Integer.valueOf(s2);
    }

    public static int parseIfInt(String s2, int def) {
        if (s2 == null || s2.length() == 0) {
            return def;
        }
        s2 = s2.trim();
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.isDigit(s2.charAt(i))) continue;
            return def;
        }
        return Integer.parseInt(s2);
    }
}

