/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.mongo.common;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceLocator {
    private static final String USER_KEY = "USERNAME";
    private static final String DB_KEY = "DBNAME";
    private static final String PASS_KEY = "PASSWORD";
    private static final int COUNT = 30;
    private static final int testFlag = 0;
    private static final int proFlag = 1;
    private static final int extFlag = 2;
    private static final int extTestFlag = 3;
    private DB reportdb;
    private DB coredb;
    private static ServiceLocator me;

    private ServiceLocator() throws Exception {
        try {
            this.initDBConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDBConnection() throws Exception {
        this.reportdb = this.getReportDB();
        this.coredb = this.getCoreDB();
    }

    public static ServiceLocator getInstance() {
        return me;
    }

    public DB getDB(String dbname) throws Exception {
        if (this.reportdb == null) {
            this.reportdb = this.getReportDB();
        }
        if (this.reportdb == null) {
            this.coredb = this.getCoreDB();
        }
        if (dbname.equals("core")) {
            return this.coredb;
        }
        return this.reportdb;
    }

    private DB getReportDB() throws Exception {
        MongoClient mc = this.initConnection("report");
        DB db = mc.getDB("report");
        return db;
    }

    private DB getCoreDB() throws Exception {
        MongoClient mc = this.initConnection("core");
        DB db = mc.getDB("core");
        return db;
    }

    private MongoClient initConnection(String dbtype) throws UnknownHostException {
        HashMap envMap = new HashMap();
        ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>();
        int envFlag = this.getEnvFlag();
        if (envFlag == 0 || envFlag == 3) {
            this.initTestEnv(envMap, serverAddressList, dbtype, envFlag);
        } else {
            this.initProduct(envMap, serverAddressList, dbtype, envFlag);
        }
        MongoClientOptions customClientOptions = new MongoClientOptions.Builder().connectionsPerHost(30).autoConnectRetry(true).build();
        List<MongoCredential> credentialsList = Arrays.asList(MongoCredential.createMongoCRCredential((String)envMap.get(USER_KEY), (String)envMap.get(DB_KEY), ((String)envMap.get(PASS_KEY)).toCharArray()));
        System.out.println(serverAddressList + " " + dbtype);
        MongoClient mc = new MongoClient((ServerAddress)serverAddressList.get(0), credentialsList, customClientOptions);
        return mc;
    }

    private int getEnvFlag() {
        List<String> proList = Arrays.asList("ProductEnv");
        List<String> extList = Arrays.asList("ExtranetEnv");
        List<String> extTestList = Arrays.asList("ExtranetTest");
        String environmenTypeCode = System.getProperty("environmenTypeCode");
        if (environmenTypeCode != null) {
            for (String keyword : proList) {
                if (!environmenTypeCode.startsWith(keyword)) continue;
                return 1;
            }
            for (String keyword : extList) {
                if (!environmenTypeCode.startsWith(keyword)) continue;
                return 2;
            }
            for (String keyword : extTestList) {
                if (!environmenTypeCode.startsWith(keyword)) continue;
                return 3;
            }
        }
        return 0;
    }

    private void initProduct(Map envMap, List<ServerAddress> serverAddressList, String dbtype, int envFlag) throws UnknownHostException {
        String host = "10.11.1.102";
        if (envFlag == 2) {
            host = "192.168.193.72";
        }
        if (dbtype.equals("report")) {
            serverAddressList.add(new ServerAddress(host, 9411));
            envMap.put(USER_KEY, "report");
            envMap.put(DB_KEY, "report");
            envMap.put(PASS_KEY, "report123");
        } else {
            serverAddressList.add(new ServerAddress(host, 9411));
            envMap.put(USER_KEY, "busiuser");
            envMap.put(DB_KEY, "core");
            envMap.put(PASS_KEY, "coreprd");
        }
    }

    private void initTestEnv(Map envMap, List<ServerAddress> serverAddressList, String dbtype, int envFlag) throws UnknownHostException {
        String host = "10.13.1.50";
        if (envFlag == 3) {
            host = "192.168.195.150";
        }
        if (dbtype.equals("report")) {
            serverAddressList.add(new ServerAddress(host, 9411));
            envMap.put(USER_KEY, "report");
            envMap.put(DB_KEY, "report");
            envMap.put(PASS_KEY, "report");
        } else {
            serverAddressList.add(new ServerAddress(host, 9413));
            envMap.put(USER_KEY, "core");
            envMap.put(DB_KEY, "core");
            envMap.put(PASS_KEY, "core");
        }
    }

    static {
        try {
            me = new ServiceLocator();
        }
        catch (Exception se) {
            se.printStackTrace(System.err);
        }
    }
}

