/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.mongo.service;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.sinosoft.mongo.service.MongoService;
import com.sinosoft.mongo.service.asyn.MongoServiceActor;
import com.typesafe.config.ConfigFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.jongo.Find;
import org.jongo.FindOne;
import org.jongo.Jongo;
import org.jongo.MongoCollection;

public abstract class MongoServiceImpl
implements MongoService {
    ActorRef serviceRef;

    public MongoServiceImpl() {
        ActorSystem system = ActorSystem.create("mongoservice", ConfigFactory.load().getConfig("MyDispatcher"));
        this.serviceRef = system.actorOf(Props.create(MongoServiceActor.class, this).withDispatcher("balancingDispatcher"));
    }

    public abstract DB getDb() throws Exception;

    public abstract String getPrefix();

    @Override
    public void insertGridFS(String strContents, String filename) throws Exception {
        GridFS gridFS = new GridFS(this.getDb(), this.getPrefix());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strContents.getBytes());
        GridFSInputFile gridFile = gridFS.createFile((InputStream)inputStream, filename);
        gridFile.save();
    }

    @Override
    public String findGridFS(String filename) throws Exception {
        GridFS gridFS = new GridFS(this.getDb(), this.getPrefix());
        GridFSDBFile file = gridFS.findOne(filename);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        file.writeTo(outStream);
        return outStream.toString();
    }

    @Override
    public void save(Object result2, String collname) throws Exception {
        Jongo jongo = new Jongo(this.getDb());
        MongoCollection col = jongo.getCollection(collname);
        col.save(result2);
    }

    @Override
    public void update(String collname, Object result2, String query, Object ... parameters) throws Exception {
        Jongo jongo = new Jongo(this.getDb());
        MongoCollection col = jongo.getCollection(collname);
        col.update(query, parameters).with(result2);
    }

    @Override
    public Find find(String collname, String query, Object ... parameters) throws Exception {
        Jongo jongo = new Jongo(this.getDb());
        MongoCollection col = jongo.getCollection(collname);
        return col.find(query, parameters);
    }

    @Override
    public FindOne findOne(String collname, String query, Object ... parameters) throws Exception {
        Jongo jongo = new Jongo(this.getDb());
        MongoCollection col = jongo.getCollection(collname);
        return col.findOne(query, parameters);
    }

    @Override
    public void insertGridFS(String strContents, String filename, boolean asyn) throws Exception {
        if (asyn) {
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put("method", "insertGridFS");
            params.put("strContents", strContents);
            params.put("filename", filename);
            this.serviceRef.tell(params, null);
        } else {
            this.insertGridFS(strContents, filename);
        }
    }

    @Override
    public void save(Object result2, String collname, boolean asyn) throws Exception {
        if (asyn) {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("method", "save");
            params.put("result", result2);
            params.put("collname", collname);
            this.serviceRef.tell(params, null);
        } else {
            this.save(result2, collname);
        }
    }

    @Override
    public void updateById(String collname, Object result2, boolean asyn, String query, Object id) throws Exception {
        if (asyn) {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("method", "update");
            params.put("collname", collname);
            params.put("result", result2);
            params.put("query", query);
            params.put("id", id);
            this.serviceRef.tell(params, null);
        } else {
            this.update(collname, result2, query, id);
        }
    }
}

