/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private final int size;
    private int count = 0;
    private boolean eof = false;
    private int mark;

    public BoundedInputStream(InputStream in, int size2) {
        super(in);
        this.size = size2;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.eof && this.count < this.size) {
            int read = super.read();
            if (read == -1) {
                this.eof = true;
            } else {
                ++this.count;
            }
            return read;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len2) throws IOException {
        if (this.eof || this.count >= this.size) {
            return -1;
        }
        int read = super.read(b, off, len2 = Math.min(len2, this.size - this.count));
        if (read == -1) {
            this.eof = true;
        } else {
            this.count += read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        n = Math.min(n, (long)(this.size - this.count));
        long skipped = super.skip(n);
        this.count = (int)((long)this.count + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.size - this.count);
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.count;
        super.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        if (super.markSupported()) {
            this.count = this.mark;
        }
        super.reset();
    }
}

