/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.BSONException;

public class BSONByteBuffer {
    protected ByteBuffer buf;

    private BSONByteBuffer(ByteBuffer buf) {
        this.buf = buf;
        buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static BSONByteBuffer wrap(byte[] bytes, int offset, int length) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes, offset, length));
    }

    public static BSONByteBuffer wrap(byte[] bytes) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes));
    }

    public byte get(int i) {
        return this.buf.get(i);
    }

    public ByteBuffer get(byte[] bytes, int offset, int length) {
        return this.buf.get(bytes, offset, length);
    }

    public ByteBuffer get(byte[] bytes) {
        return this.buf.get(bytes);
    }

    public byte[] array() {
        return this.buf.array();
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BSONByteBuffer that = (BSONByteBuffer)o;
        return !(this.buf != null ? !this.buf.equals(that.buf) : that.buf != null);
    }

    public int getInt(int i) {
        return this.getIntLE(i);
    }

    public int getIntLE(int i) {
        int x = 0;
        x |= (0xFF & this.buf.get(i + 0)) << 0;
        x |= (0xFF & this.buf.get(i + 1)) << 8;
        x |= (0xFF & this.buf.get(i + 2)) << 16;
        return x |= (0xFF & this.buf.get(i + 3)) << 24;
    }

    public int getIntBE(int i) {
        int x = 0;
        x |= (0xFF & this.buf.get(i + 0)) << 24;
        x |= (0xFF & this.buf.get(i + 1)) << 16;
        x |= (0xFF & this.buf.get(i + 2)) << 8;
        return x |= (0xFF & this.buf.get(i + 3)) << 0;
    }

    public long getLong(int i) {
        return this.buf.getLong(i);
    }

    public String getCString(int offset) {
        int end = offset;
        while (this.get(end) != 0) {
            ++end;
        }
        int len2 = end - offset;
        return new String(this.array(), offset, len2);
    }

    public String getUTF8String(int valueOffset) {
        int size2 = this.getInt(valueOffset) - 1;
        try {
            return new String(this.array(), valueOffset + 4, size2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BSONException("Cannot decode string as UTF-8.");
        }
    }

    public Buffer position(int i) {
        return this.buf.position(i);
    }

    public Buffer reset() {
        return this.buf.reset();
    }

    public int size() {
        return this.getInt(0);
    }
}

