/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregate {
    private final DB db;
    private final String collectionName;
    private final Unmarshaller unmarshaller;
    private final QueryFactory queryFactory;
    private final List<DBObject> pipeline;

    Aggregate(DB db, String collectionName, Unmarshaller unmarshaller, QueryFactory queryFactory) {
        this.db = db;
        this.collectionName = collectionName;
        this.unmarshaller = unmarshaller;
        this.queryFactory = queryFactory;
        this.pipeline = new ArrayList<DBObject>();
    }

    public Aggregate and(String pipelineOperator, Object ... parameters) {
        DBObject dbQuery = this.queryFactory.createQuery(pipelineOperator, parameters).toDBObject();
        this.pipeline.add(dbQuery);
        return this;
    }

    public <T> List<T> as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> List<T> map(ResultHandler<T> resultHandler) {
        List<DBObject> results = this.executeAggregateCommand();
        ArrayList<T> mappedResult = new ArrayList<T>(results.size());
        for (DBObject dbObject : results) {
            mappedResult.add(resultHandler.map(dbObject));
        }
        return mappedResult;
    }

    private List<DBObject> executeAggregateCommand() {
        CommandResult commandResult = this.db.command(this.createCommand());
        commandResult.throwOnError();
        return (List)commandResult.get("result");
    }

    DBObject createCommand() {
        BasicDBObject cmd = new BasicDBObject("aggregate", this.collectionName);
        cmd.put("pipeline", (Object)this.pipeline);
        return cmd;
    }
}

