/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    private final DB db;
    private final Unmarshaller unmarshaller;
    private final QueryFactory queryFactory;
    private Query query;
    private boolean throwOnError;

    public Command(DB db, Unmarshaller unmarshaller, QueryFactory queryFactory, String query, Object ... parameters) {
        this.db = db;
        this.unmarshaller = unmarshaller;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery(query, parameters);
    }

    public Command throwOnError() {
        this.throwOnError = true;
        return this;
    }

    public ResultCommand field(String fieldName) {
        return new ResultCommand(fieldName);
    }

    public <T> T as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> T map(ResultHandler<T> resultHandler) {
        CommandResult commandResult = this.executeCommand();
        return resultHandler.map(commandResult);
    }

    private CommandResult executeCommand() {
        CommandResult commandResult = this.db.command(this.query.toDBObject());
        if (this.throwOnError) {
            commandResult.throwOnError();
        }
        return commandResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResultCommand {
        private String fieldName;

        public ResultCommand(String fieldName) {
            this.fieldName = fieldName;
        }

        public <T> List<T> as(Class<T> clazz) {
            return this.map(ResultHandlerFactory.newResultHandler(clazz, Command.this.unmarshaller));
        }

        public <T> List<T> map(ResultHandler<T> resultHandler) {
            CommandResult commandResult = Command.this.executeCommand();
            List results = (List)commandResult.get(this.fieldName);
            if (results == null) {
                return new ArrayList();
            }
            ArrayList<T> mappedResult = new ArrayList<T>(results.size());
            for (DBObject dbObject : results) {
                mappedResult.add(resultHandler.map(dbObject));
            }
            return mappedResult;
        }
    }
}

