/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distinct {
    private final DBCollection dbCollection;
    private final Unmarshaller unmarshaller;
    private final String key;
    private Query query;
    private final QueryFactory queryFactory;

    Distinct(DBCollection dbCollection, Unmarshaller unmarshaller, QueryFactory queryFactory, String key) {
        this.dbCollection = dbCollection;
        this.unmarshaller = unmarshaller;
        this.key = key;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery("{}", new Object[0]);
    }

    public Distinct query(String query) {
        this.query = this.queryFactory.createQuery(query, new Object[0]);
        return this;
    }

    public Distinct query(String query, Object ... parameters) {
        this.query = this.queryFactory.createQuery(query, parameters);
        return this;
    }

    public <T> List<T> as(Class<T> clazz) {
        DBObject ref = this.query.toDBObject();
        List distinct2 = this.dbCollection.distinct(this.key, ref);
        if (distinct2.isEmpty() || this.resultsAreBSONPrimitive(distinct2)) {
            return distinct2;
        }
        return this.typedList(distinct2, clazz);
    }

    private boolean resultsAreBSONPrimitive(List<?> distinct2) {
        return !(distinct2.get(0) instanceof DBObject);
    }

    private <T> List<T> typedList(List<DBObject> distinct2, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        ResultHandler<T> handler = ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller);
        for (DBObject dbObject : distinct2) {
            results.add(handler.map(dbObject));
        }
        return results;
    }
}

