/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOne {
    private final Unmarshaller unmarshaller;
    private final DBCollection collection;
    private final ReadPreference readPreference;
    private final Query query;
    private Query fields;
    private Query orderBy;
    private final QueryFactory queryFactory;

    FindOne(DBCollection collection, ReadPreference readPreference, Unmarshaller unmarshaller, QueryFactory queryFactory, String query, Object ... parameters) {
        this.unmarshaller = unmarshaller;
        this.collection = collection;
        this.readPreference = readPreference;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery(query, parameters);
    }

    public <T> T as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> T map(ResultHandler<T> resultHandler) {
        DBObject result2 = this.collection.findOne(this.query.toDBObject(), this.getFieldsAsDBObject(), this.getOrderByAsDBObject(), this.readPreference);
        return result2 == null ? null : (T)resultHandler.map(result2);
    }

    public FindOne projection(String fields) {
        this.fields = this.queryFactory.createQuery(fields, new Object[0]);
        return this;
    }

    public FindOne projection(String fields, Object ... parameters) {
        this.fields = this.queryFactory.createQuery(fields, parameters);
        return this;
    }

    public FindOne orderBy(String orderBy) {
        this.orderBy = this.queryFactory.createQuery(orderBy, new Object[0]);
        return this;
    }

    private DBObject getFieldsAsDBObject() {
        return this.fields == null ? null : this.fields.toDBObject();
    }

    private DBObject getOrderByAsDBObject() {
        return this.orderBy == null ? null : this.orderBy.toDBObject();
    }
}

