/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.BasicDBList;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.LazyWriteableDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import org.bson.LazyBSONCallback;
import org.bson.types.ObjectId;
import org.jongo.ObjectIdUpdater;
import org.jongo.bson.Bson;
import org.jongo.bson.BsonDocument;
import org.jongo.marshall.Marshaller;
import org.jongo.query.QueryFactory;

class Insert {
    private final Marshaller marshaller;
    private final DBCollection collection;
    private final ObjectIdUpdater objectIdUpdater;
    private final QueryFactory queryFactory;
    private WriteConcern writeConcern;

    Insert(DBCollection collection, WriteConcern writeConcern, Marshaller marshaller, ObjectIdUpdater objectIdUpdater, QueryFactory queryFactory) {
        this.writeConcern = writeConcern;
        this.marshaller = marshaller;
        this.collection = collection;
        this.objectIdUpdater = objectIdUpdater;
        this.queryFactory = queryFactory;
    }

    public WriteResult save(Object pojo) {
        Object id = this.preparePojo(pojo);
        DBObject dbo = this.convertToDBObject(pojo, id);
        return this.collection.save(dbo, this.writeConcern);
    }

    public WriteResult insert(Object ... pojos) {
        ArrayList<DBObject> dbos = new ArrayList<DBObject>(pojos.length);
        for (Object pojo : pojos) {
            Object id = this.preparePojo(pojo);
            DBObject dbo = this.convertToDBObject(pojo, id);
            dbos.add(dbo);
        }
        return this.collection.insert(dbos, this.writeConcern);
    }

    public WriteResult insert(String query, Object ... parameters) {
        DBObject dbQuery = this.queryFactory.createQuery(query, parameters).toDBObject();
        if (dbQuery instanceof BasicDBList) {
            return this.insert(((BasicDBList)dbQuery).toArray());
        }
        return this.collection.insert(dbQuery, this.writeConcern);
    }

    private Object preparePojo(Object pojo) {
        if (this.objectIdUpdater.mustGenerateObjectId(pojo)) {
            ObjectId newOid = ObjectId.get();
            this.objectIdUpdater.setObjectId(pojo, newOid);
            return newOid;
        }
        return this.objectIdUpdater.getId(pojo);
    }

    private DBObject convertToDBObject(Object pojo, Object id) {
        BsonDocument document = Insert.asBsonDocument(this.marshaller, pojo);
        return new LazyIdDBObject(document.toByteArray(), this.marshaller, id);
    }

    private static BsonDocument asBsonDocument(Marshaller marshaller, Object obj) {
        try {
            return marshaller.marshall(obj);
        }
        catch (Exception e) {
            String message = String.format("Unable to save object %s due to a marshalling error", obj);
            throw new IllegalArgumentException(message, e);
        }
    }

    private static final class LazyIdDBObject
    extends LazyWriteableDBObject {
        private final Object id;
        private final Marshaller marshaller;

        private LazyIdDBObject(byte[] data, Marshaller marshaller, Object id) {
            super(data, new LazyBSONCallback());
            this.marshaller = marshaller;
            this.id = id;
        }

        public Object get(String key) {
            if ("_id".equals(key) && this.id != null) {
                if (Bson.isPrimitive(this.id)) {
                    return this.id;
                }
                return Insert.asBsonDocument(this.marshaller, this.id).toDBObject();
            }
            return super.get(key);
        }
    }
}

