/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import org.jongo.Command;
import org.jongo.Mapper;
import org.jongo.MongoCollection;
import org.jongo.bson.BsonDBDecoder;
import org.jongo.bson.BsonDBEncoder;
import org.jongo.marshall.jackson.JacksonMapper;
import org.jongo.query.Query;

public class Jongo {
    private final DB database;
    private final Mapper mapper;

    public Jongo(DB database) {
        this(database, new JacksonMapper.Builder().build());
    }

    public Jongo(DB database, Mapper mapper) {
        this.database = database;
        this.mapper = mapper;
    }

    public MongoCollection getCollection(String name) {
        DBCollection dbCollection = this.database.getCollection(name);
        dbCollection.setDBDecoderFactory(BsonDBDecoder.FACTORY);
        dbCollection.setDBEncoderFactory(BsonDBEncoder.FACTORY);
        return new MongoCollection(dbCollection, this.mapper);
    }

    public DB getDatabase() {
        return this.database;
    }

    public Query createQuery(String query, Object ... parameters) {
        return this.mapper.getQueryFactory().createQuery(query, parameters);
    }

    public Command runCommand(String query) {
        return this.runCommand(query, new Object[0]);
    }

    public Command runCommand(String query, Object ... parameters) {
        return new Command(this.database, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), query, parameters);
    }
}

