/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jongo.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoCursor<E>
implements Iterator<E>,
Iterable<E>,
Closeable {
    private final DBCursor cursor;
    private final ResultHandler<E> resultHandler;

    public MongoCursor(DBCursor cursor, ResultHandler<E> resultHandler) {
        this.cursor = cursor;
        this.resultHandler = resultHandler;
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DBObject dbObject = this.cursor.next();
        return this.resultHandler.map(dbObject);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    @Override
    public Iterator<E> iterator() {
        return new MongoCursor<E>(this.cursor.copy(), this.resultHandler);
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }

    public int count() {
        return this.cursor.count();
    }
}

